/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import java.awt.Cursor;
import javax.swing.JComponent;

public class CursorManager {
    private boolean waiting = false;
    private boolean draggingTable = false;
    private boolean dragAllModeActive = false;
    private boolean placeModeActive = false;
    private boolean dragLineActive = false;
    private JComponent component;

    public CursorManager(JComponent component) {
        this.component = component;
    }

    public void tableDragStarted() {
        this.draggingTable = true;
        this.modifyCursorImage();
    }

    public void tableDragFinished() {
        this.draggingTable = false;
        this.modifyCursorImage();
    }

    public void dragAllModeStarted() {
        this.dragAllModeActive = true;
        this.modifyCursorImage();
    }

    public void dragAllModeFinished() {
        this.dragAllModeActive = false;
        this.modifyCursorImage();
    }

    public void placeModeStarted() {
        this.placeModeActive = true;
        this.modifyCursorImage();
    }

    public void placeModeFinished() {
        this.placeModeActive = false;
        this.modifyCursorImage();
    }

    public void startWaitMode() {
        this.waiting = true;
        this.modifyCursorImage();
    }

    public void finishWaitMode() {
        this.waiting = false;
        this.modifyCursorImage();
    }

    public void dragLineStarted() {
        this.dragLineActive = true;
        this.modifyCursorImage();
    }

    public void dragLineFinished() {
        this.dragLineActive = false;
        this.modifyCursorImage();
    }

    private void modifyCursorImage() {
        if (this.dragAllModeActive || this.draggingTable) {
            this.component.setCursor(Cursor.getPredefinedCursor(13));
        } else if (this.placeModeActive) {
            this.component.setCursor(Cursor.getPredefinedCursor(1));
        } else if (this.waiting) {
            this.component.setCursor(Cursor.getPredefinedCursor(3));
        } else if (this.dragLineActive) {
            this.component.setCursor(Cursor.getPredefinedCursor(10));
        } else {
            this.component.setCursor(null);
        }
    }
}

