/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.expression.AbstractLineNumberTypeExpression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.PrimitiveTypeUtil;

public class IntegerConstantExpression
extends AbstractLineNumberTypeExpression {
    protected int value;

    public IntegerConstantExpression(Type type, int value) {
        super(type);
        this.value = value;
        assert (type.isPrimitive());
    }

    public IntegerConstantExpression(int lineNumber, Type type, int value) {
        super(lineNumber, type);
        this.value = value;
        assert (type.isPrimitive());
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public void setType(Type type) {
        assert (type.isPrimitive() && this.checkType(type)) : "setType : incompatible types";
        super.setType(type);
    }

    protected boolean checkType(Type type) {
        if (type.isPrimitive()) {
            switch (PrimitiveTypeUtil.getStandardPrimitiveTypeFlags(((PrimitiveType)type).getFlags())) {
                case 16: {
                    return -128 <= this.value && this.value <= 127;
                }
                case 2: {
                    return '\u0000' <= (char)this.value && (char)this.value <= '\uffff';
                }
                case 32: {
                    return Short.MIN_VALUE <= this.value && this.value <= Short.MAX_VALUE;
                }
                case 1: {
                    return 0 <= this.value && this.value <= 1;
                }
            }
            return Integer.MIN_VALUE <= this.value && this.value <= Integer.MAX_VALUE;
        }
        return false;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "IntegerConstantExpression{type=" + this.type + ", value=" + this.value + "}";
    }
}

