/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.tools.view.ServletUtils;
import org.apache.velocity.tools.view.VelocityView;
import org.slf4j.Logger;

public class VelocityViewServlet
extends HttpServlet {
    public static final String BUFFER_OUTPUT_PARAM = "org.apache.velocity.tools.bufferOutput";
    private static final long serialVersionUID = -3329444102562079189L;
    private transient VelocityView view;
    private boolean bufferOutput = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.getVelocityView();
        String buffer = this.findInitParameter(config, BUFFER_OUTPUT_PARAM);
        if (buffer != null && buffer.equals("true")) {
            this.bufferOutput = true;
            this.getLog().debug("VelocityViewServlet will buffer mergeTemplate output.");
        }
    }

    protected String findInitParameter(ServletConfig config, String key) {
        String param = config.getInitParameter(key);
        if (param == null || param.length() == 0) {
            ServletContext servletContext = config.getServletContext();
            param = servletContext.getInitParameter(key);
        }
        return param;
    }

    protected VelocityView getVelocityView() {
        if (this.view == null) {
            this.setVelocityView(ServletUtils.getVelocityView(this.getServletConfig()));
            assert (this.view != null);
        }
        return this.view;
    }

    protected void setVelocityView(VelocityView view) {
        this.view = view;
    }

    protected String getVelocityProperty(String name, String alternate) {
        return this.getVelocityView().getProperty(name, alternate);
    }

    protected Logger getLog() {
        return this.getVelocityView().getLog();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Context context = null;
        try {
            this.initRequest(request, response);
            context = this.createContext(request, response);
            this.fillContext(context, request);
            this.setContentType(request, response);
            Template template = this.handleRequest(request, response, context);
            this.mergeTemplate(template, context, response);
        }
        catch (IOException e) {
            this.error(request, response, e);
            throw e;
            catch (ResourceNotFoundException e2) {
                this.manageResourceNotFound(request, response, e2);
                this.requestCleanup(request, response, context);
                return;
            }
            catch (RuntimeException e3) {
                try {
                    this.error(request, response, e3);
                    throw e3;
                }
                catch (Throwable throwable) {
                    this.requestCleanup(request, response, context);
                    throw throwable;
                }
            }
        }
        this.requestCleanup(request, response, context);
        return;
    }

    protected void initRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            request.setCharacterEncoding(this.getVelocityProperty("input.encoding", "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            this.error(request, response, uee);
            throw uee;
        }
    }

    protected Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context ctx) {
        return this.getTemplate(request, response);
    }

    protected Context createContext(HttpServletRequest request, HttpServletResponse response) {
        return this.getVelocityView().createContext(request, response);
    }

    protected void fillContext(Context context, HttpServletRequest request) {
    }

    protected void setContentType(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(this.getVelocityView().getDefaultContentType());
    }

    protected Template getTemplate(HttpServletRequest request, HttpServletResponse response) {
        return this.getVelocityView().getTemplate(request);
    }

    protected Template getTemplate(String name) {
        return this.getVelocityView().getTemplate(name);
    }

    protected void mergeTemplate(Template template, Context context, HttpServletResponse response) throws IOException {
        Writer writer = this.bufferOutput ? new StringWriter() : response.getWriter();
        this.getVelocityView().merge(template, context, writer);
        if (this.bufferOutput) {
            response.getWriter().write(writer.toString());
        }
    }

    protected void error(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        String path = ServletUtils.getPath(request);
        if (response.isCommitted()) {
            this.getLog().error("An error occured but the response headers have already been sent.");
            this.getLog().error("Error processing a template for path '{}'", (Object)path, (Object)e);
            return;
        }
        try {
            this.getLog().error("Error processing a template for path '{}'", (Object)path, (Object)e);
            StringBuilder html = new StringBuilder();
            html.append("<html>\n");
            html.append("<head><title>Error</title></head>\n");
            html.append("<body>\n");
            html.append("<h2>VelocityView : Error processing a template for path '");
            html.append(path);
            html.append("'</h2>\n");
            Throwable cause = e;
            String why = cause.getMessage();
            if (why != null && why.length() > 0) {
                html.append(StringEscapeUtils.escapeHtml4((String)why));
                html.append("\n<br>\n");
            }
            if (cause instanceof MethodInvocationException) {
                cause = cause.getCause();
            }
            StringWriter sw = new StringWriter();
            cause.printStackTrace(new PrintWriter(sw));
            html.append("<pre>\n");
            html.append(StringEscapeUtils.escapeHtml4((String)sw.toString()));
            html.append("</pre>\n");
            html.append("</body>\n");
            html.append("</html>");
            response.getWriter().write(html.toString());
        }
        catch (Exception e2) {
            String msg = "Exception while printing error screen";
            this.getLog().error(msg, (Throwable)e2);
            throw new RuntimeException(msg, e);
        }
    }

    protected void manageResourceNotFound(HttpServletRequest request, HttpServletResponse response, ResourceNotFoundException e) throws IOException {
        String path = ServletUtils.getPath(request);
        this.getLog().debug("Resource not found for path '{}'", (Object)path, (Object)e);
        String message = e.getMessage();
        if (response.isCommitted() || path == null || message == null || !message.contains("'" + path + "'")) {
            this.error(request, response, e);
            throw e;
        }
        response.sendError(404, path);
    }

    protected void requestCleanup(HttpServletRequest request, HttpServletResponse response, Context context) {
    }
}

