/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class DescribeEvaluator
extends RecursiveNumericEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;

    public DescribeEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (!(value instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a numeric list but found %s", this.toExpression(this.constructingFactory), value.getClass().getSimpleName()));
        }
        DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics();
        ((List)value).stream().mapToDouble(innerValue -> ((Number)innerValue).doubleValue()).forEach(innerValue -> descriptiveStatistics.addValue(innerValue));
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("max", descriptiveStatistics.getMax());
        map.put("mean", descriptiveStatistics.getMean());
        map.put("min", descriptiveStatistics.getMin());
        map.put("stdev", descriptiveStatistics.getStandardDeviation());
        map.put("sum", descriptiveStatistics.getSum());
        map.put("N", descriptiveStatistics.getN());
        map.put("var", descriptiveStatistics.getVariance());
        map.put("kurtosis", descriptiveStatistics.getKurtosis());
        map.put("skewness", descriptiveStatistics.getSkewness());
        map.put("popVar", descriptiveStatistics.getPopulationVariance());
        map.put("geometricMean", descriptiveStatistics.getGeometricMean());
        map.put("sumsq", descriptiveStatistics.getSumsq());
        return new Tuple(map);
    }
}

