/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value;

import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import org.apache.solr.common.SolrException;

public interface AnalyticsValueStream {
    public String getName();

    public String getExpressionStr();

    public void streamObjects(Consumer<Object> var1);

    public AnalyticsValueStream convertToConstant();

    public ExpressionType getExpressionType();

    public static String createExpressionString(String funcName, AnalyticsValueStream ... params) {
        return String.format(Locale.ROOT, "%s(%s)", funcName, Arrays.stream(params).map(param -> param.getExpressionStr()).reduce((a, b) -> a + "," + b).orElseGet(() -> ""));
    }

    public static ExpressionType determineMappingPhase(String exprString, AnalyticsValueStream ... params) throws SolrException {
        boolean unreduced = true;
        boolean reduced = true;
        for (AnalyticsValueStream param : params) {
            unreduced &= param.getExpressionType().isUnreduced();
            reduced &= param.getExpressionType().isReduced();
        }
        if (unreduced && reduced) {
            return ExpressionType.CONST;
        }
        if (unreduced) {
            return ExpressionType.UNREDUCED_MAPPING;
        }
        if (reduced) {
            return ExpressionType.REDUCED_MAPPING;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The following expression contains incorrect parameters. (ReductionFunctions cannot be in the paramters of other ReductionFunctions): " + exprString);
    }

    public static enum ExpressionType {
        CONST(true, true),
        FIELD(true, false),
        UNREDUCED_MAPPING(true, false),
        REDUCTION(false, true),
        REDUCED_MAPPING(false, true);

        private final boolean unreduced;
        private final boolean reduced;

        private ExpressionType(boolean unreduced, boolean reduced) {
            this.unreduced = unreduced;
            this.reduced = reduced;
        }

        public boolean isUnreduced() {
            return this.unreduced;
        }

        public boolean isReduced() {
            return this.reduced;
        }
    }

    public static abstract class AbstractAnalyticsValueStream
    implements AnalyticsValueStream {
        @Override
        public AnalyticsValueStream convertToConstant() {
            return this;
        }
    }
}

