/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Allocate;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.ArrayValue;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Contract;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.CycleException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Loader;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.ObjectValue;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Reference;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Value;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Node;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.NodeMap;
import java.util.HashMap;

class ReadGraph
extends HashMap {
    private final Loader loader;
    private final String length;
    private final String label;
    private final String mark;
    private final String refer;

    public ReadGraph(Contract contract, Loader loader) {
        this.refer = contract.getReference();
        this.mark = contract.getIdentity();
        this.length = contract.getLength();
        this.label = contract.getLabel();
        this.loader = loader;
    }

    public Value read(Type type, NodeMap nodeMap) {
        Node node = nodeMap.remove(this.label);
        Class clazz = type.getType();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (node != null) {
            String string = node.getValue();
            clazz = this.loader.load(string);
        }
        return this.readInstance(type, clazz, nodeMap);
    }

    private Value readInstance(Type type, Class clazz, NodeMap nodeMap) {
        Node node = nodeMap.remove(this.mark);
        if (node == null) {
            return this.readReference(type, clazz, nodeMap);
        }
        String string = node.getValue();
        if (this.containsKey(string)) {
            throw new CycleException("Element '%s' already exists", string);
        }
        return this.readValue(type, clazz, nodeMap, string);
    }

    private Value readReference(Type type, Class clazz, NodeMap nodeMap) {
        Node node = nodeMap.remove(this.refer);
        if (node == null) {
            return this.readValue(type, clazz, nodeMap);
        }
        String string = node.getValue();
        Object v = this.get(string);
        if (!this.containsKey(string)) {
            throw new CycleException("Invalid reference '%s' found", string);
        }
        return new Reference(v, clazz);
    }

    private Value readValue(Type type, Class clazz, NodeMap nodeMap) {
        Class clazz2 = type.getType();
        if (clazz2.isArray()) {
            return this.readArray(type, clazz, nodeMap);
        }
        return new ObjectValue(clazz);
    }

    private Value readValue(Type type, Class clazz, NodeMap nodeMap, String string) {
        Value value = this.readValue(type, clazz, nodeMap);
        if (string != null) {
            return new Allocate(value, this, string);
        }
        return value;
    }

    private Value readArray(Type type, Class clazz, NodeMap nodeMap) {
        Node node = nodeMap.remove(this.length);
        int n = 0;
        if (node != null) {
            String string = node.getValue();
            n = Integer.parseInt(string);
        }
        return new ArrayValue(clazz, n);
    }
}

