/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling.sim;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.common.cloud.LiveNodesListener;

public class LiveNodesSet
implements Iterable<String> {
    private final Set<String> set = ConcurrentHashMap.newKeySet();
    private final Set<LiveNodesListener> listeners = ConcurrentHashMap.newKeySet();

    public Set<String> get() {
        return Collections.unmodifiableSet(this.set);
    }

    public int size() {
        return this.set.size();
    }

    public void registerLiveNodesListener(LiveNodesListener listener) {
        this.listeners.add(listener);
    }

    public void removeLiveNodesListener(LiveNodesListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllLiveNodesListeners() {
        this.listeners.clear();
    }

    private void fireListeners(SortedSet<String> oldNodes, SortedSet<String> newNodes) {
        for (LiveNodesListener listener : this.listeners) {
            listener.onChange(oldNodes, newNodes);
        }
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public boolean contains(String id) {
        return this.set.contains(id);
    }

    public synchronized boolean add(String id) {
        if (this.set.contains(id)) {
            return false;
        }
        TreeSet<String> oldNodes = new TreeSet<String>(this.set);
        this.set.add(id);
        TreeSet<String> newNodes = new TreeSet<String>(this.set);
        this.fireListeners(oldNodes, newNodes);
        return true;
    }

    public synchronized boolean addAll(Collection<String> nodes) {
        TreeSet<String> oldNodes = new TreeSet<String>(this.set);
        boolean changed = this.set.addAll(nodes);
        TreeSet<String> newNodes = new TreeSet<String>(this.set);
        if (changed) {
            this.fireListeners(oldNodes, newNodes);
        }
        return changed;
    }

    public synchronized boolean remove(String id) {
        if (!this.set.contains(id)) {
            return false;
        }
        TreeSet<String> oldNodes = new TreeSet<String>(this.set);
        this.set.remove(id);
        TreeSet<String> newNodes = new TreeSet<String>(this.set);
        this.fireListeners(oldNodes, newNodes);
        return true;
    }

    public synchronized void clear() {
        TreeSet<String> oldNodes = new TreeSet<String>(this.set);
        this.set.clear();
        this.fireListeners(oldNodes, Collections.emptySortedSet());
    }

    @Override
    public Iterator<String> iterator() {
        return this.set.iterator();
    }
}

