/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters.solr;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.util.stats.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrReporter
extends ScheduledReporter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String REGISTRY_ID = "_registry_";
    public static final String REPORTER_ID = "_reporter_";
    public static final String GROUP_ID = "_group_";
    public static final String LABEL_ID = "_label_";
    private String reporterId;
    private String handler;
    private Supplier<String> urlProvider;
    private SolrClientCache clientCache;
    private List<CompiledReport> compiledReports;
    private SolrMetricManager metricManager;
    private boolean skipHistograms;
    private boolean skipAggregateValues;
    private boolean cloudClient;
    private boolean compact;
    private ModifiableSolrParams params;
    private Map<String, Object> metadata;

    public SolrReporter(HttpClient httpClient, Supplier<String> urlProvider, SolrMetricManager metricManager, List<Report> metrics, String handler, String reporterId, TimeUnit rateUnit, TimeUnit durationUnit, SolrParams params, boolean skipHistograms, boolean skipAggregateValues, boolean cloudClient, boolean compact) {
        super(null, "solr-reporter", MetricFilter.ALL, rateUnit, durationUnit, null, true);
        this.metricManager = metricManager;
        this.urlProvider = urlProvider;
        this.reporterId = reporterId;
        if (handler == null) {
            handler = "/admin/metrics/collector";
        }
        this.handler = handler;
        this.clientCache = new SolrClientCache(httpClient);
        this.compiledReports = new ArrayList<CompiledReport>();
        metrics.forEach(report -> {
            SolrMetricManager.RegexFilter filter = new SolrMetricManager.RegexFilter(report.metricFilters);
            try {
                CompiledReport cs = new CompiledReport((Report)report);
                this.compiledReports.add(cs);
            }
            catch (PatternSyntaxException e) {
                log.warn("Skipping report with invalid registryPattern: " + report.registryPattern, (Throwable)e);
            }
        });
        this.skipHistograms = skipHistograms;
        this.skipAggregateValues = skipAggregateValues;
        this.cloudClient = cloudClient;
        this.compact = compact;
        this.params = new ModifiableSolrParams();
        this.params.set(REPORTER_ID, new String[]{reporterId});
        if (params != null) {
            this.params.add(params);
        }
        this.metadata = new HashMap<String, Object>();
        this.metadata.put(REPORTER_ID, reporterId);
    }

    public void close() {
        this.clientCache.close();
        super.close();
    }

    public void report() {
        String url = this.urlProvider.get();
        if (url == null) {
            return;
        }
        Object solr = this.cloudClient ? this.clientCache.getCloudSolrClient(url) : this.clientCache.getHttpSolrClient(url);
        UpdateRequest req = new UpdateRequest(this.handler);
        req.setParams(this.params);
        this.compiledReports.forEach(report -> {
            Set<String> registryNames = this.metricManager.registryNames(report.registryPattern);
            registryNames.forEach(registryName -> {
                String label = report.label;
                if (label != null && label.indexOf(36) != -1) {
                    Matcher m = report.registryPattern.matcher((CharSequence)registryName);
                    label = m.replaceFirst(label);
                }
                String effectiveLabel = label;
                String group = report.group;
                if (group.indexOf(36) != -1) {
                    Matcher m = report.registryPattern.matcher((CharSequence)registryName);
                    group = m.replaceFirst(group);
                }
                String effectiveGroup = group;
                MetricUtils.toSolrInputDocuments(this.metricManager.registry((String)registryName), Collections.singletonList(report.filter), MetricFilter.ALL, MetricUtils.PropertyFilter.ALL, this.skipHistograms, this.skipAggregateValues, this.compact, this.metadata, doc -> {
                    doc.setField(REGISTRY_ID, registryName);
                    doc.setField(GROUP_ID, (Object)effectiveGroup);
                    if (effectiveLabel != null) {
                        doc.setField(LABEL_ID, (Object)effectiveLabel);
                    }
                    req.add(doc);
                });
            });
        });
        if (req.getDocuments() == null || req.getDocuments().isEmpty()) {
            return;
        }
        try {
            solr.request((SolrRequest)req);
        }
        catch (Exception e) {
            log.debug("Error sending metric report", (Object)e.toString());
        }
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
    }

    private static final class CompiledReport {
        String group;
        String label;
        Pattern registryPattern;
        MetricFilter filter;

        CompiledReport(Report report) throws PatternSyntaxException {
            this.group = report.groupPattern;
            this.label = report.labelPattern;
            this.registryPattern = Pattern.compile(report.registryPattern);
            this.filter = new SolrMetricManager.RegexFilter(report.metricFilters);
        }

        public String toString() {
            return "CompiledReport{group='" + this.group + '\'' + ", label='" + this.label + '\'' + ", registryPattern=" + this.registryPattern + ", filter=" + this.filter + '}';
        }
    }

    public static class Builder {
        private final SolrMetricManager metricManager;
        private final List<Report> reports;
        private String reporterId;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private String handler;
        private boolean skipHistograms;
        private boolean skipAggregateValues;
        private boolean cloudClient;
        private boolean compact;
        private SolrParams params;

        public static Builder forReports(SolrMetricManager metricManager, List<Report> reports) {
            return new Builder(metricManager, reports);
        }

        private Builder(SolrMetricManager metricManager, List<Report> reports) {
            this.metricManager = metricManager;
            this.reports = reports;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.skipHistograms = false;
            this.skipAggregateValues = false;
            this.cloudClient = false;
            this.compact = true;
            this.params = null;
        }

        public Builder withSolrParams(SolrParams params) {
            this.params = params;
            return this;
        }

        public Builder cloudClient(boolean cloudClient) {
            this.cloudClient = cloudClient;
            return this;
        }

        public Builder setCompact(boolean compact) {
            this.compact = compact;
            return this;
        }

        public Builder skipHistograms(boolean skipHistograms) {
            this.skipHistograms = skipHistograms;
            return this;
        }

        public Builder skipAggregateValues(boolean skipAggregateValues) {
            this.skipAggregateValues = skipAggregateValues;
            return this;
        }

        public Builder withHandler(String handler) {
            this.handler = handler;
            return this;
        }

        public Builder withReporterId(String reporterId) {
            this.reporterId = reporterId;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public SolrReporter build(HttpClient client, Supplier<String> urlProvider) {
            return new SolrReporter(client, urlProvider, this.metricManager, this.reports, this.handler, this.reporterId, this.rateUnit, this.durationUnit, this.params, this.skipHistograms, this.skipAggregateValues, this.cloudClient, this.compact);
        }
    }

    public static final class Report {
        public String groupPattern;
        public String labelPattern;
        public String registryPattern;
        public Set<String> metricFilters = new HashSet<String>();

        public Report(String groupPattern, String labelPattern, String registryPattern, Collection<String> metricFilters) {
            this.groupPattern = groupPattern;
            this.labelPattern = labelPattern;
            this.registryPattern = registryPattern;
            if (metricFilters != null) {
                this.metricFilters.addAll(metricFilters);
            }
        }

        public static Report fromMap(Map<?, ?> map) {
            String groupPattern = (String)map.get("group");
            String labelPattern = (String)map.get("label");
            String registryPattern = (String)map.get("registry");
            Object oFilters = map.get("filter");
            List<String> metricFilters = Collections.emptyList();
            if (oFilters != null) {
                if (oFilters instanceof String) {
                    metricFilters = Collections.singletonList((String)oFilters);
                } else if (oFilters instanceof Collection) {
                    metricFilters = (Collection)oFilters;
                } else {
                    log.warn("Invalid report filters, ignoring: " + oFilters);
                }
            }
            if (groupPattern == null || registryPattern == null) {
                log.warn("Invalid report configuration, group and registry required!: " + map);
                return null;
            }
            return new Report(groupPattern, labelPattern, registryPattern, metricFilters);
        }
    }
}

