/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;

public abstract class ActionsBridge {
    private static RequestProcessor RP = new RequestProcessor("Module-Actions", Integer.MAX_VALUE);

    protected abstract void invokeAction(Action var1, ActionEvent var2);

    public static void doPerformAction(CallableSystemAction callableSystemAction, final ActionRunnable actionRunnable) {
        assert (EventQueue.isDispatchThread()) : "Action " + callableSystemAction.getClass().getName() + " may not be invoked from the thread " + Thread.currentThread().getName() + ", only the event queue: http://www.netbeans.org/download/4_1/javadoc/OpenAPIs/apichanges.html#actions-event-thread";
        if (actionRunnable.async && !actionRunnable.needsToBeSynchronous()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    actionRunnable.doRun();
                }
            };
            RP.post(runnable);
        } else {
            actionRunnable.run();
        }
    }

    public static abstract class ActionRunnable
    implements Action {
        final ActionEvent ev;
        final SystemAction action;
        final boolean async;

        public ActionRunnable(ActionEvent actionEvent, SystemAction systemAction, boolean bl) {
            this.ev = actionEvent;
            this.action = systemAction;
            this.async = bl;
        }

        public final boolean needsToBeSynchronous() {
            return "waitFinished".equals(this.ev.getActionCommand());
        }

        public final void doRun() {
            ActionsBridge actionsBridge = Lookup.getDefault().lookup(ActionsBridge.class);
            if (actionsBridge != null) {
                actionsBridge.invokeAction(this, this.ev);
            } else {
                this.actionPerformed(this.ev);
            }
        }

        protected abstract void run();

        public final void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException();
        }

        public final Object getValue(String string) {
            return this.action.getValue(string);
        }

        public final boolean isEnabled() {
            return this.action.isEnabled();
        }

        public final void putValue(String string, Object object) {
            throw new UnsupportedOperationException();
        }

        public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException();
        }

        public final void setEnabled(boolean bl) {
            throw new UnsupportedOperationException();
        }
    }
}

