/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public final class NumberSequence
implements SchemaObject {
    public static final NumberSequence[] emptyArray = new NumberSequence[0];
    private HsqlNameManager.HsqlName name;
    private long currValue;
    private long lastValue;
    private boolean limitReached;
    private long startValue;
    private long minValue;
    private long maxValue;
    private long increment;
    private Type dataType;
    private boolean isCycle;
    private boolean isAlways;
    private boolean restartValueDefault;

    public NumberSequence(HsqlNameManager.HsqlName hsqlName, Type type) {
        this.setDefaults(hsqlName, type);
    }

    public void setDefaults(HsqlNameManager.HsqlName hsqlName, Type type) {
        long l;
        long l2;
        this.name = hsqlName;
        this.dataType = type;
        switch (this.dataType.typeCode) {
            case -6: {
                l2 = 127L;
                l = -128L;
                break;
            }
            case 5: {
                l2 = 32767L;
                l = -32768L;
                break;
            }
            case 4: {
                l2 = Integer.MAX_VALUE;
                l = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                l2 = Long.MAX_VALUE;
                l = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                if (type.scale == 0) {
                    l2 = Long.MAX_VALUE;
                    l = Long.MIN_VALUE;
                    break;
                }
            }
            default: {
                throw Error.error(5563);
            }
        }
        this.minValue = l;
        this.maxValue = l2;
        this.increment = 1L;
    }

    public NumberSequence(HsqlNameManager.HsqlName hsqlName, long l, long l2, Type type) {
        this(hsqlName, type);
        this.setStartValue(l);
        this.setIncrement(l2);
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("CREATE").append(' ');
        stringBuffer.append("SEQUENCE").append(' ');
        stringBuffer.append(this.getName().getSchemaQualifiedStatementName()).append(' ');
        stringBuffer.append("AS").append(' ');
        stringBuffer.append(this.getDataType().getNameString()).append(' ');
        stringBuffer.append("START").append(' ');
        stringBuffer.append("WITH").append(' ');
        stringBuffer.append(this.startValue);
        if (this.getIncrement() != 1L) {
            stringBuffer.append(' ').append("INCREMENT").append(' ');
            stringBuffer.append("BY").append(' ');
            stringBuffer.append(this.getIncrement());
        }
        if (!this.hasDefaultMinMax()) {
            stringBuffer.append(' ').append("MINVALUE").append(' ');
            stringBuffer.append(this.getMinValue());
            stringBuffer.append(' ').append("MAXVALUE").append(' ');
            stringBuffer.append(this.getMaxValue());
        }
        if (this.isCycle()) {
            stringBuffer.append(' ').append("CYCLE");
        }
        if (this.name == null) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String getSQLColumnDefinition() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("GENERATED").append(' ');
        if (this.name == null) {
            if (this.isAlways()) {
                stringBuffer.append("ALWAYS");
            } else {
                stringBuffer.append("BY").append(' ').append("DEFAULT");
            }
            stringBuffer.append(' ').append("AS").append(' ').append("IDENTITY").append("(");
            stringBuffer.append("START").append(' ');
            stringBuffer.append("WITH").append(' ');
            stringBuffer.append(this.startValue);
            if (this.getIncrement() != 1L) {
                stringBuffer.append(' ').append("INCREMENT").append(' ');
                stringBuffer.append("BY").append(' ');
                stringBuffer.append(this.getIncrement());
            }
            if (!this.hasDefaultMinMax()) {
                stringBuffer.append(' ').append("MINVALUE").append(' ');
                stringBuffer.append(this.getMinValue());
                stringBuffer.append(' ').append("MAXVALUE").append(' ');
                stringBuffer.append(this.getMaxValue());
            }
            if (this.isCycle()) {
                stringBuffer.append(' ').append("CYCLE");
            }
            if (this.name == null) {
                stringBuffer.append(")");
            }
        } else {
            stringBuffer.append("BY").append(' ').append("DEFAULT");
            stringBuffer.append(' ').append("AS").append(' ');
            stringBuffer.append("SEQUENCE").append(' ');
            stringBuffer.append(this.getName().getSchemaQualifiedStatementName());
        }
        return stringBuffer.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String getRestartSQL() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("ALTER").append(' ');
        stringBuffer.append("SEQUENCE");
        stringBuffer.append(' ').append(this.name.getSchemaQualifiedStatementName());
        stringBuffer.append(' ').append("RESTART");
        stringBuffer.append(' ').append("WITH").append(' ').append(this.peek());
        return stringBuffer.toString();
    }

    public static String getRestartSQL(Table table) {
        String string = table.getColumn((int)table.identityColumn).getName().statementName;
        NumberSequence numberSequence = table.identitySequence;
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("ALTER").append(' ').append("TABLE");
        stringBuffer.append(' ').append(table.getName().getSchemaQualifiedStatementName());
        stringBuffer.append(' ').append("ALTER").append(' ');
        stringBuffer.append("COLUMN");
        stringBuffer.append(' ').append(string);
        stringBuffer.append(' ').append("RESTART");
        stringBuffer.append(' ').append("WITH").append(' ').append(numberSequence.peek());
        return stringBuffer.toString();
    }

    public Type getDataType() {
        return this.dataType;
    }

    public long getIncrement() {
        return this.increment;
    }

    public synchronized long getStartValue() {
        return this.startValue;
    }

    public synchronized long getMinValue() {
        return this.minValue;
    }

    public synchronized long getMaxValue() {
        return this.maxValue;
    }

    public synchronized boolean isCycle() {
        return this.isCycle;
    }

    public synchronized boolean isAlways() {
        return this.isAlways;
    }

    public synchronized boolean hasDefaultMinMax() {
        long l;
        long l2;
        switch (this.dataType.typeCode) {
            case -6: {
                l2 = 127L;
                l = -128L;
                break;
            }
            case 5: {
                l2 = 32767L;
                l = -32768L;
                break;
            }
            case 4: {
                l2 = Integer.MAX_VALUE;
                l = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                l2 = Long.MAX_VALUE;
                l = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                l2 = Long.MAX_VALUE;
                l = Long.MIN_VALUE;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberSequence");
            }
        }
        return this.minValue == l && this.maxValue == l2;
    }

    synchronized void setStartValue(long l) {
        if (l < this.minValue || l > this.maxValue) {
            throw Error.error(5597);
        }
        this.currValue = this.lastValue = (this.startValue = l);
    }

    synchronized void setMinValue(long l) {
        this.checkInTypeRange(l);
        if (l >= this.maxValue || this.currValue < l) {
            throw Error.error(5597);
        }
        this.minValue = l;
    }

    synchronized void setDefaultMinValue() {
        this.minValue = this.getDefaultMinOrMax(false);
    }

    synchronized void setMaxValue(long l) {
        this.checkInTypeRange(l);
        if (l <= this.minValue || this.currValue > l) {
            throw Error.error(5597);
        }
        this.maxValue = l;
    }

    synchronized void setDefaultMaxValue() {
        this.maxValue = this.getDefaultMinOrMax(true);
    }

    synchronized void setIncrement(long l) {
        if (l < -16384L || l > 16383L) {
            throw Error.error(5597);
        }
        this.increment = l;
    }

    synchronized void setCurrentValueNoCheck(long l) {
        this.checkInTypeRange(l);
        this.currValue = this.lastValue = l;
    }

    synchronized void setStartValueNoCheck(long l) {
        this.checkInTypeRange(l);
        this.currValue = this.lastValue = (this.startValue = l);
    }

    synchronized void setStartValueDefault() {
        this.restartValueDefault = true;
    }

    synchronized void setMinValueNoCheck(long l) {
        this.checkInTypeRange(l);
        this.minValue = l;
    }

    synchronized void setMaxValueNoCheck(long l) {
        this.checkInTypeRange(l);
        this.maxValue = l;
    }

    synchronized void setCycle(boolean bl) {
        this.isCycle = bl;
    }

    synchronized void setAlways(boolean bl) {
        this.isAlways = bl;
    }

    private long getDefaultMinOrMax(boolean bl) {
        long l;
        long l2;
        switch (this.dataType.typeCode) {
            case -6: {
                l2 = 127L;
                l = -128L;
                break;
            }
            case 5: {
                l2 = 32767L;
                l = -32768L;
                break;
            }
            case 4: {
                l2 = Integer.MAX_VALUE;
                l = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                l2 = Long.MAX_VALUE;
                l = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                l2 = Long.MAX_VALUE;
                l = Long.MIN_VALUE;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberSequence");
            }
        }
        return bl ? l2 : l;
    }

    private void checkInTypeRange(long l) {
        long l2;
        long l3;
        switch (this.dataType.typeCode) {
            case -6: {
                l3 = 127L;
                l2 = -128L;
                break;
            }
            case 5: {
                l3 = 32767L;
                l2 = -32768L;
                break;
            }
            case 4: {
                l3 = Integer.MAX_VALUE;
                l2 = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                l3 = Long.MAX_VALUE;
                l2 = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                l3 = Long.MAX_VALUE;
                l2 = Long.MIN_VALUE;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberSequence");
            }
        }
        if (l < l2 || l > l3) {
            throw Error.error(5597);
        }
    }

    synchronized void checkValues() {
        if (this.restartValueDefault) {
            this.currValue = this.lastValue = this.startValue;
            this.restartValueDefault = false;
        }
        if (this.minValue >= this.maxValue || this.startValue < this.minValue || this.startValue > this.maxValue || this.currValue < this.minValue || this.currValue > this.maxValue) {
            throw Error.error(5597);
        }
    }

    synchronized NumberSequence duplicate() {
        NumberSequence numberSequence = new NumberSequence(this.name, this.dataType);
        numberSequence.startValue = this.startValue;
        numberSequence.currValue = this.currValue;
        numberSequence.lastValue = this.lastValue;
        numberSequence.increment = this.increment;
        numberSequence.minValue = this.minValue;
        numberSequence.maxValue = this.maxValue;
        numberSequence.isCycle = this.isCycle;
        numberSequence.isAlways = this.isAlways;
        return numberSequence;
    }

    synchronized void reset(NumberSequence numberSequence) {
        this.name = numberSequence.name;
        this.startValue = numberSequence.startValue;
        this.currValue = numberSequence.currValue;
        this.lastValue = numberSequence.lastValue;
        this.increment = numberSequence.increment;
        this.dataType = numberSequence.dataType;
        this.minValue = numberSequence.minValue;
        this.maxValue = numberSequence.maxValue;
        this.isCycle = numberSequence.isCycle;
        this.isAlways = numberSequence.isAlways;
    }

    synchronized long userUpdate(long l) {
        if (l == this.currValue) {
            this.currValue += this.increment;
            return l;
        }
        if (this.increment > 0L) {
            if (l > this.currValue) {
                this.currValue += (l - this.currValue + this.increment) / this.increment * this.increment;
            }
        } else if (l < this.currValue) {
            this.currValue += (l - this.currValue + this.increment) / this.increment * this.increment;
        }
        return l;
    }

    synchronized long systemUpdate(long l) {
        if (l == this.currValue) {
            this.currValue += this.increment;
            return l;
        }
        if (this.increment > 0L) {
            if (l > this.currValue) {
                this.currValue = l + this.increment;
            }
        } else if (l < this.currValue) {
            this.currValue = l + this.increment;
        }
        return l;
    }

    synchronized Object getValueObject() {
        Number number;
        long l = this.getValue();
        switch (this.dataType.typeCode) {
            default: {
                number = ValuePool.getInt((int)l);
                break;
            }
            case 25: {
                number = ValuePool.getLong(l);
                break;
            }
            case 2: 
            case 3: {
                number = ValuePool.getBigDecimal(new BigDecimal(l));
            }
        }
        return number;
    }

    public synchronized long getValue() {
        long l;
        if (this.limitReached) {
            throw Error.error(3416);
        }
        if (this.increment > 0L) {
            if (this.currValue > this.maxValue - this.increment) {
                if (this.isCycle) {
                    l = this.minValue;
                } else {
                    this.limitReached = true;
                    l = this.minValue;
                }
            } else {
                l = this.currValue + this.increment;
            }
        } else if (this.currValue < this.minValue - this.increment) {
            if (this.isCycle) {
                l = this.maxValue;
            } else {
                this.limitReached = true;
                l = this.minValue;
            }
        } else {
            l = this.currValue + this.increment;
        }
        long l2 = this.currValue;
        this.currValue = l;
        return l2;
    }

    synchronized void reset() {
        this.lastValue = this.currValue = this.startValue;
    }

    public synchronized long peek() {
        return this.currValue;
    }

    synchronized boolean resetWasUsed() {
        boolean bl = this.lastValue != this.currValue;
        this.lastValue = this.currValue;
        return bl;
    }

    public synchronized void reset(long l) {
        if (l < this.minValue || l > this.maxValue) {
            throw Error.error(5597);
        }
        this.currValue = this.lastValue = l;
        this.startValue = this.lastValue;
    }
}

