/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmlinput;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.trans.steps.xmlinput.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLInputFieldPosition
implements Cloneable {
    public static final int XML_ELEMENT = 1;
    public static final int XML_ATTRIBUTE = 2;
    public static final int XML_ROOT = 3;
    public static final String NR_MARKER = "/";
    private String name;
    private int type;
    private int elementNr;

    public XMLInputFieldPosition(String name, int type) {
        this.name = name;
        this.type = type;
        this.elementNr = 1;
    }

    public XMLInputFieldPosition(String name, int type, int elementNr) {
        this.name = name;
        this.type = type;
        this.elementNr = elementNr;
    }

    public String toString() {
        String enc = "";
        switch (this.type) {
            case 1: {
                enc = enc + "E";
                break;
            }
            case 2: {
                enc = enc + "A";
                break;
            }
            case 3: {
                enc = enc + "R";
                break;
            }
            default: {
                enc = enc + "?";
            }
        }
        enc = enc + "=";
        enc = enc + this.name;
        enc = enc + NR_MARKER + (this.elementNr <= 0 ? 1 : this.elementNr);
        return enc;
    }

    public XMLInputFieldPosition(String encoded) throws KettleValueException {
        String nameAndNumber;
        int equalIndex = encoded.indexOf(61);
        if (equalIndex < 0) {
            throw new KettleValueException(Messages.getString("XMLInputFieldPosition.Exception.InvalidXMLFieldPosition", encoded));
        }
        String positionType = Const.trim((String)encoded.substring(0, equalIndex));
        String positionName = nameAndNumber = Const.trim((String)encoded.substring(equalIndex + 1));
        int semiIndex = nameAndNumber.indexOf(NR_MARKER);
        if (semiIndex >= 0) {
            this.elementNr = Const.toInt((String)nameAndNumber.substring(semiIndex + 1), (int)1);
            positionName = nameAndNumber.substring(0, semiIndex);
        } else {
            this.elementNr = 1;
        }
        if (positionType.equalsIgnoreCase("E")) {
            this.type = 1;
            this.name = positionName;
        } else if (positionType.equalsIgnoreCase("A")) {
            this.type = 2;
            this.name = positionName;
        } else if (positionType.equalsIgnoreCase("R")) {
            this.type = 3;
            this.name = positionName;
        } else {
            throw new KettleValueException(Messages.getString("XMLInputFieldPosition.Exception.WrongPositionType", positionType));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getElementNr() {
        return this.elementNr;
    }

    public void setElementNr(int elementNr) {
        this.elementNr = elementNr;
    }

    public static final String encodePath(List<XMLInputFieldPosition> path) {
        String encoded = "";
        for (int p = 0; p < path.size(); ++p) {
            XMLInputFieldPosition pos = path.get(p);
            String elementName = pos.toString();
            if (p > 0) {
                encoded = encoded + ",";
            }
            encoded = encoded + elementName;
        }
        return encoded;
    }
}

