/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getxmldata;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.Namespace;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.AbstractNode;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataData;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataField;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataMeta;
import org.pentaho.di.trans.steps.getxmldata.Messages;

public class GetXMLData
extends BaseStep
implements StepInterface {
    private GetXMLDataMeta meta;
    private GetXMLDataData data;

    public GetXMLData(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    protected boolean setDocument(String StringXML, FileObject file, boolean IsInXMLField, boolean readurl) throws KettleException {
        try {
            SAXReader reader = new SAXReader();
            this.data.stopPruning = false;
            if (this.meta.isValidating()) {
                reader.setValidation(true);
                reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            if (this.meta.isIgnoreComments()) {
                reader.setIgnoreComments(true);
            }
            if (this.data.prunePath != null) {
                if (this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("GetXMLData.Log.StreamingMode.Activated"));
                }
                reader.addHandler(this.data.prunePath, new ElementHandler(){

                    public void onStart(ElementPath path) {
                    }

                    public void onEnd(ElementPath path) {
                        if (GetXMLData.this.isStopped()) {
                            if (GetXMLData.this.log.isBasic()) {
                                GetXMLData.this.logBasic(Messages.getString("GetXMLData.Log.StreamingMode.Stopped"));
                            }
                            ((GetXMLData)GetXMLData.this).data.stopPruning = true;
                            path.getCurrent().getDocument().detach();
                            return;
                        }
                        if (GetXMLData.this.log.isDebug()) {
                            GetXMLData.this.logDebug(Messages.getString("GetXMLData.Log.StreamingMode.StartProcessing"));
                        }
                        Element row = path.getCurrent();
                        try {
                            GetXMLData.this.processStreaming(row.getDocument());
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        row.detach();
                        if (GetXMLData.this.log.isDebug()) {
                            GetXMLData.this.logDebug(Messages.getString("GetXMLData.Log.StreamingMode.EndProcessing"));
                        }
                    }
                });
            }
            if (IsInXMLField) {
                this.data.document = reader.read((Reader)new StringReader(StringXML));
            } else if (readurl) {
                this.data.document = reader.read(new URL(StringXML));
            } else {
                String encoding = "UTF-8";
                if (!Const.isEmpty((String)this.meta.getEncoding())) {
                    encoding = this.meta.getEncoding();
                }
                this.data.document = reader.read(KettleVFS.getInputStream((FileObject)file), encoding);
            }
            if (this.meta.isNamespaceAware()) {
                this.prepareNSMap(this.data.document.getRootElement());
            }
        }
        catch (Exception e) {
            if (this.data.stopPruning) {
                return false;
            }
            throw new KettleException((Throwable)e);
        }
        return true;
    }

    private void processStreaming(Document document) throws KettleException {
        this.data.document = document;
        if (this.meta.isNamespaceAware()) {
            this.prepareNSMap(this.data.document.getRootElement());
        }
        if (this.log.isDebug()) {
            this.logDebug(Messages.getString("GetXMLData.Log.StreamingMode.ApplyXPath"));
        }
        if (!this.applyXPath()) {
            throw new KettleException(Messages.getString("GetXMLData.Log.UnableApplyXPath"));
        }
        if (this.log.isDebug()) {
            this.logDebug(Messages.getString("GetXMLData.Log.StreamingMode.ProcessingRows"));
        }
        boolean cont = true;
        while (this.data.nodenr < this.data.nodesize && cont && !this.isStopped()) {
            Object[] r = this.getXMLRowPutRowWithErrorhandling();
            if (this.data.errorInRowButContinue) continue;
            cont = this.putRowOut(r);
        }
        if (this.log.isDebug()) {
            this.logDebug(Messages.getString("GetXMLData.Log.StreamingMode.FreeMemory"));
        }
        this.data.an.clear();
        this.data.nodesize = this.data.an.size();
        this.data.nodenr = 0;
    }

    public void prepareNSMap(Element l) {
        for (Namespace ns : l.declaredNamespaces()) {
            if (ns.getPrefix().trim().length() == 0) {
                this.data.NAMESPACE.put("pre" + this.data.NSPath.size(), ns.getURI());
                String path = "";
                for (Element element = l; element != null; element = element.getParent()) {
                    path = element.getNamespacePrefix() != null && element.getNamespacePrefix().length() > 0 ? "/" + element.getNamespacePrefix() + ":" + element.getName() + path : "/" + element.getName() + path;
                }
                this.data.NSPath.add(path);
                continue;
            }
            this.data.NAMESPACE.put(ns.getPrefix(), ns.getURI());
        }
        for (Element e : l.elements()) {
            this.prepareNSMap(e);
        }
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    private void handleMissingFiles() throws KettleException {
        List nonExistantFiles = this.data.files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.log.logError(Messages.getString("GetXMLData.Log.RequiredFilesTitle"), Messages.getString("GetXMLData.Log.RequiredFiles", message), new Object[0]);
            throw new KettleException(Messages.getString("GetXMLData.Log.RequiredFilesMissing", message));
        }
        List nonAccessibleFiles = this.data.files.getNonAccessibleFiles();
        if (nonAccessibleFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.log.logError(Messages.getString("GetXMLData.Log.RequiredFilesTitle"), Messages.getString("GetXMLData.Log.RequiredNotAccessibleFiles", message), new Object[0]);
            throw new KettleException(Messages.getString("GetXMLData.Log.RequiredNotAccessibleFilesMissing", message));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ReadNextString() {
        try {
            this.data.readrow = this.getRow();
            if (this.data.readrow == null) {
                if (!this.log.isDetailed()) return false;
                this.logDetailed(Messages.getString("GetXMLData.Log.FinishedProcessing"));
                return false;
            }
            if (this.first) {
                this.first = false;
                if (this.meta.isInFields()) {
                    int i;
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                    if (Const.isEmpty((String)this.meta.getXMLField())) {
                        this.logError(Messages.getString("GetXMLData.Log.NoField"));
                        throw new KettleException(Messages.getString("GetXMLData.Log.NoField"));
                    }
                    if (this.data.indexOfXmlField < 0) {
                        this.data.indexOfXmlField = this.getInputRowMeta().indexOfValue(this.meta.getXMLField());
                        if (this.data.indexOfXmlField < 0) {
                            this.logError(Messages.getString("GetXMLData.Log.ErrorFindingField") + "[" + this.meta.getXMLField() + "]");
                            throw new KettleException(Messages.getString("GetXMLData.Exception.CouldnotFindField", this.meta.getXMLField()));
                        }
                    }
                }
            }
            if (!this.meta.isInFields()) return true;
            String Fieldvalue = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfXmlField);
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), Messages.getString("GetXMLData.Log.XMLStream", this.meta.getXMLField(), Fieldvalue), new Object[0]);
            }
            if (this.meta.getIsAFile()) {
                FileObject file = null;
                try {
                    try {
                        file = KettleVFS.getFileObject((String)Fieldvalue);
                        if (!this.setDocument(null, file, false, false)) {
                            throw new KettleException(Messages.getString("GetXMLData.Log.UnableCreateDocument"));
                        }
                        if (!this.applyXPath()) {
                            throw new KettleException(Messages.getString("GetXMLData.Log.UnableApplyXPath"));
                        }
                        this.addFileToResultFilesname(file);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), Messages.getString("GetXMLData.Log.LoopFileOccurences", "" + this.data.nodesize, file.getName().getBaseName()), new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        throw new KettleException((Throwable)e);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        if (file == null) throw throwable;
                        file.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception e) {}
                if (file == null) return true;
                file.close();
                return true;
            }
            boolean url = false;
            boolean xmltring = true;
            if (this.meta.isReadUrl()) {
                url = true;
                xmltring = false;
            }
            if (!this.setDocument(Fieldvalue, null, xmltring, url)) {
                throw new KettleException(Messages.getString("GetXMLData.Log.UnableCreateDocument"));
            }
            if (!this.applyXPath()) {
                throw new KettleException(Messages.getString("GetXMLData.Log.UnableApplyXPath"));
            }
            if (!this.log.isDetailed()) return true;
            this.log.logDetailed(this.toString(), Messages.getString("GetXMLData.Log.LoopFileOccurences", "" + this.data.nodesize), new Object[0]);
            return true;
        }
        catch (Exception e) {
            this.logError(Messages.getString("GetXMLData.Log.UnexpectedError", e.toString()));
            this.stopAll();
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            return false;
        }
    }

    private void addFileToResultFilesname(FileObject file) throws Exception {
        if (this.meta.addResultFile()) {
            ResultFile resultFile = new ResultFile(0, file, this.getTransMeta().getName(), this.getStepname());
            resultFile.setComment(Messages.getString("GetXMLData.Log.FileAddedResult"));
            this.addResultFile(resultFile);
        }
    }

    public String addNSPrefix(String path, String loopPath) {
        if (this.data.NSPath.size() > 0) {
            String fullPath = loopPath;
            if (!path.equals(fullPath)) {
                for (String tmp : path.split("/")) {
                    fullPath = tmp.equals("..") ? fullPath.substring(0, fullPath.lastIndexOf("/")) : fullPath + "/" + tmp;
                }
            }
            int[] indexs = new int[fullPath.split("/").length - 1];
            Arrays.fill(indexs, -1);
            int length = 0;
            for (int i = 0; i < this.data.NSPath.size(); ++i) {
                if (this.data.NSPath.get(i).length() <= length || !fullPath.startsWith(this.data.NSPath.get(i))) continue;
                Arrays.fill(indexs, this.data.NSPath.get(i).split("/").length - 2, indexs.length, i);
                length = this.data.NSPath.get(i).length();
            }
            StringBuilder newPath = new StringBuilder();
            String[] pathStrs = path.split("/");
            for (int i = 0; i < pathStrs.length; ++i) {
                String tmp = pathStrs[i];
                if (newPath.length() > 0) {
                    newPath.append("/");
                }
                if (tmp.length() > 0 && tmp.indexOf(":") == -1 && tmp.indexOf(".") == -1 && tmp.indexOf("@") == -1) {
                    int index = indexs[i + indexs.length - pathStrs.length];
                    if (index >= 0) {
                        newPath.append("pre").append(index).append(":").append(tmp);
                        continue;
                    }
                    newPath.append(tmp);
                    continue;
                }
                newPath.append(tmp);
            }
            return newPath.toString();
        }
        return path;
    }

    private boolean applyXPath() {
        try {
            XPath xpath = this.data.document.createXPath(this.data.PathValue);
            if (this.meta.isNamespaceAware()) {
                xpath = this.data.document.createXPath(this.addNSPrefix(this.data.PathValue, this.data.PathValue));
                xpath.setNamespaceURIs(this.data.NAMESPACE);
            }
            this.data.an = xpath.selectNodes((Object)this.data.document);
            this.data.nodesize = this.data.an.size();
            this.data.nodenr = 0;
        }
        catch (Exception e) {
            this.log.logError(this.toString(), Messages.getString("GetXMLData.Log.ErrorApplyXPath", e.getMessage()), new Object[0]);
            return false;
        }
        return true;
    }

    private boolean openNextFile() {
        try {
            if (this.data.filenr >= this.data.files.nrOfFiles()) {
                if (this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("GetXMLData.Log.FinishedProcessing"));
                }
                return false;
            }
            this.data.last_file = this.data.filenr == this.data.files.nrOfFiles() - 1;
            this.data.file = this.data.files.getFile(this.data.filenr);
            long fileSize = this.data.file.getContent().getSize();
            ++this.data.filenr;
            if (this.meta.isIgnoreEmptyFile() && fileSize == 0L) {
                this.log.logBasic(this.toString(), Messages.getString("GetXMLData.Error.FileSizeZero", "" + this.data.file.getName()), new Object[0]);
                this.openNextFile();
            } else {
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), Messages.getString("GetXMLData.Log.OpeningFile", this.data.file.toString()), new Object[0]);
                }
                if (!this.setDocument(null, this.data.file, false, false)) {
                    if (this.data.stopPruning) {
                        return false;
                    }
                    throw new KettleException(Messages.getString("GetXMLData.Log.UnableCreateDocument"));
                }
                if (this.data.prunePath == null && !this.applyXPath()) {
                    throw new KettleException(Messages.getString("GetXMLData.Log.UnableApplyXPath"));
                }
                this.addFileToResultFilesname(this.data.file);
                if (this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("GetXMLData.Log.FileOpened", this.data.file.toString()));
                    this.log.logDetailed(this.toString(), Messages.getString("GetXMLData.Log.LoopFileOccurences", "" + this.data.nodesize, this.data.file.getName().getBaseName()), new Object[0]);
                }
            }
        }
        catch (Exception e) {
            this.logError(Messages.getString("GetXMLData.Log.UnableToOpenFile", "" + this.data.filenr, this.data.file.toString(), e.toString()));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.first && !this.meta.isInFields()) {
            int i;
            this.data.files = this.meta.getFiles(this);
            if (!this.meta.isdoNotFailIfNoFile() && this.data.files.nrOfFiles() == 0) {
                throw new KettleException(Messages.getString("GetXMLData.Log.NoFiles"));
            }
            this.handleMissingFiles();
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.convertRowMeta = this.data.outputRowMeta.clone();
            for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                this.data.convertRowMeta.getValueMeta(i).setType(2);
            }
            this.data.convertRowMeta = this.data.outputRowMeta.clone();
            for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                this.data.convertRowMeta.getValueMeta(i).setType(2);
            }
        }
        Object[] r = this.getXMLRow();
        if (this.data.errorInRowButContinue) {
            return true;
        }
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        return this.putRowOut(r);
    }

    private boolean putRowOut(Object[] r) throws KettleException {
        if (this.log.isRowLevel()) {
            this.logRowlevel(Messages.getString("GetXMLData.Log.ReadRow", r.toString()));
        }
        this.incrementLinesInput();
        ++this.data.rownr;
        this.putRow(this.data.outputRowMeta, r);
        if (this.meta.getRowLimit() > 0L && this.data.rownr > this.meta.getRowLimit()) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private Object[] getXMLRow() throws KettleException {
        if (!this.meta.isInFields()) {
            while (this.data.nodenr >= this.data.nodesize || this.data.file == null) {
                if (this.openNextFile()) continue;
                this.data.errorInRowButContinue = false;
                return null;
            }
        }
        return this.getXMLRowPutRowWithErrorhandling();
    }

    private Object[] getXMLRowPutRowWithErrorhandling() throws KettleException {
        Object[] r = null;
        this.data.errorInRowButContinue = false;
        try {
            if (this.meta.isInFields()) {
                while (this.data.nodenr >= this.data.nodesize || this.data.readrow == null) {
                    if (!this.ReadNextString()) {
                        return null;
                    }
                    if (this.data.readrow != null) continue;
                    return null;
                }
            }
            r = this.meta.isInFields() ? this.processPutRow(this.data.readrow, this.data.an.get(this.data.nodenr)) : this.processPutRow(null, this.data.an.get(this.data.nodenr));
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("GetXMLData.Error.UnableReadFile"), (Throwable)e);
        }
        return r;
    }

    private Object[] processPutRow(Object[] row, AbstractNode node) throws KettleException {
        Object[] outputRowData = this.buildEmptyRow();
        try {
            RowMetaInterface irow;
            ++this.data.nodenr;
            if (row != null) {
                outputRowData = (Object[])row.clone();
            }
            for (int i = 0; i < this.data.nrInputFields; ++i) {
                GetXMLDataField xmlDataField = this.meta.getInputFields()[i];
                String XPathValue = this.environmentSubstitute(xmlDataField.getXPath());
                String Element_Type = xmlDataField.getElementTypeCode();
                if (this.meta.isuseToken()) {
                    int indexvarstart = XPathValue.indexOf(this.data.tokenStart);
                    int indexvarend = XPathValue.indexOf(this.data.tokenEnd);
                    if (indexvarstart >= 0 && indexvarend >= 0) {
                        String NameVarInputField = XPathValue.substring(indexvarstart + 2, indexvarend);
                        for (int k = 0; k < this.meta.getInputFields().length; ++k) {
                            GetXMLDataField Tmp_xmlInputField = this.meta.getInputFields()[k];
                            if (!Tmp_xmlInputField.getName().equalsIgnoreCase(NameVarInputField)) continue;
                            XPathValue = XPathValue.replaceAll(this.data.tokenStart + NameVarInputField + this.data.tokenEnd, "'" + outputRowData[this.data.totalpreviousfields + k] + "'");
                            if (!this.log.isDetailed()) continue;
                            this.log.logDetailed(this.toString(), XPathValue, new Object[0]);
                        }
                    }
                }
                String nodevalue = null;
                if (!Element_Type.equals("node")) {
                    XPathValue = '@' + XPathValue;
                }
                if (this.meta.isNamespaceAware()) {
                    XPath xpathField = node.createXPath(this.addNSPrefix(XPathValue, this.data.PathValue));
                    xpathField.setNamespaceURIs(this.data.NAMESPACE);
                    nodevalue = xpathField.valueOf((Object)node);
                } else {
                    nodevalue = node.valueOf(XPathValue);
                }
                switch (xmlDataField.getTrimType()) {
                    case 1: {
                        nodevalue = Const.ltrim((String)nodevalue);
                        break;
                    }
                    case 2: {
                        nodevalue = Const.rtrim((String)nodevalue);
                        break;
                    }
                    case 3: {
                        nodevalue = Const.trim((String)nodevalue);
                        break;
                    }
                }
                if (this.meta.isInFields()) {
                    outputRowData = RowDataUtil.addValueData((Object[])outputRowData, (int)(this.data.totalpreviousfields + i), (Object)nodevalue);
                }
                ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(this.data.totalpreviousfields + i);
                ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(this.data.totalpreviousfields + i);
                outputRowData[this.data.totalpreviousfields + i] = targetValueMeta.convertData(sourceValueMeta, (Object)nodevalue);
                if (!this.meta.getInputFields()[i].isRepeated() || this.data.previousRow == null || !Const.isEmpty((String)nodevalue)) continue;
                outputRowData[this.data.totalpreviousfields + i] = this.data.previousRow[this.data.totalpreviousfields + i];
            }
            int rowIndex = this.data.nrInputFields;
            if (this.meta.includeFilename() && !Const.isEmpty((String)this.meta.getFilenameField())) {
                outputRowData[rowIndex++] = KettleVFS.getFilename((FileObject)this.data.file);
            }
            if (this.meta.includeRowNumber() && !Const.isEmpty((String)this.meta.getRowNumberField())) {
                outputRowData[rowIndex++] = new Long(this.data.rownr);
            }
            this.data.previousRow = (irow = this.getInputRowMeta()) == null ? outputRowData : irow.cloneRow(outputRowData);
        }
        catch (Exception e) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.data.outputRowMeta, outputRowData, 1L, e.toString(), null, "GetXMLData001");
                this.data.errorInRowButContinue = true;
                return null;
            }
            this.log.logError(this.toString(), e.toString(), new Object[0]);
            throw new KettleException(e.toString());
        }
        return outputRowData;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetXMLDataMeta)smi;
        this.data = (GetXMLDataData)sdi;
        if (super.init(smi, sdi)) {
            this.data.rownr = 1L;
            this.data.nrInputFields = this.meta.getInputFields().length;
            this.data.PathValue = this.environmentSubstitute(this.meta.getLoopXPath());
            if (!this.data.PathValue.substring(0, 1).equals("/")) {
                this.data.PathValue = "/" + this.data.PathValue;
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), Messages.getString("GetXMLData.Log.LoopXPath", this.data.PathValue), new Object[0]);
            }
            this.data.prunePath = this.environmentSubstitute(this.meta.getPrunePath());
            if (this.data.prunePath != null) {
                if (Const.isEmpty((String)this.data.prunePath.trim())) {
                    this.data.prunePath = null;
                } else {
                    if (!this.data.prunePath.startsWith("/")) {
                        this.data.prunePath = "/" + this.data.prunePath;
                    }
                    if (this.meta.isInFields()) {
                        this.data.prunePath = null;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetXMLDataMeta)smi;
        this.data = (GetXMLDataData)sdi;
        if (this.data.file != null) {
            try {
                this.data.file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

