/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.jms;

import javax.jms.ConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.soap.SoapTransport;
import org.codehaus.xfire.soap.SoapTransportHelper;
import org.codehaus.xfire.transport.AbstractTransport;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.DefaultEndpoint;
import org.codehaus.xfire.transport.jms.JMSChannel;
import org.codehaus.xfire.wsdl11.WSDL11Transport;

public class JMSTransport
extends AbstractTransport
implements SoapTransport,
WSDL11Transport {
    private static final Log log = LogFactory.getLog((Class)JMSTransport.class);
    public static final String NAME = "JMS";
    public static final String BINDING_ID = "urn:xfire:transport:jms";
    private static final String URI_PREFIX = "";
    private ConnectionFactory connectionFactory;
    private XFire xfire;

    public JMSTransport(XFire xfire, ConnectionFactory factory) {
        this.xfire = xfire;
        this.connectionFactory = factory;
        SoapTransportHelper.createSoapTransport(this);
    }

    public String getName() {
        return NAME;
    }

    public String getServiceURL(Service service) {
        return "jms://" + service.getSimpleName();
    }

    public String getTransportURI(Service service) {
        return "jms://soap";
    }

    protected Channel createNewChannel(String uri) {
        log.debug((Object)("Creating new channel for uri: " + uri));
        JMSChannel c = new JMSChannel(uri, this);
        c.setEndpoint(new DefaultEndpoint());
        return c;
    }

    protected String getUriPrefix() {
        return URI_PREFIX;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public XFire getXFire() {
        return this.xfire;
    }

    public String[] getKnownUriSchemes() {
        return new String[]{"jms://"};
    }

    public String[] getSupportedBindings() {
        return new String[]{BINDING_ID};
    }
}

