(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/address#ip4-address
    (lambda (_obj114641_)
      (if (std/net/address#ip4-address? _obj114641_)
          _obj114641_
          (if (std/net/address#ip4-address-string? _obj114641_)
              (std/net/address#string->ip4-address _obj114641_)
              (error '"Malformed ip4 address" _obj114641_)))))
  (define std/net/address#ip4-address?
    (lambda (_obj114639_)
      (if (##u8vector? _obj114639_)
          (##fx= (##u8vector-length _obj114639_) '4)
          '#f)))
  (define std/net/address#ip4-address-string?
    (lambda (_obj114637_)
      (if (string? _obj114637_)
          (if (std/pregexp#pregexp-match
               std/net/address#ip4-address-rx
               _obj114637_)
              '#t
              '#f)
          '#f)))
  (define std/net/address#ip4-address-rx
    (std/pregexp#pregexp
     '"^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$"))
  (define std/net/address#string->ip4-address
    (lambda (_str114612_)
      (let* ((_g114613114620_
              (std/pregexp#pregexp-match
               std/net/address#ip4-address-rx
               _str114612_))
             (_E114615114624_
              (lambda () (error '"No clause matching" _g114613114620_)))
             (_K114616114629_
              (lambda (_octets114627_)
                (apply ##u8vector (map string->number _octets114627_)))))
        (if (##pair? _g114613114620_)
            (let* ((_tl114618114632_ (##cdr _g114613114620_))
                   (_octets114635_ _tl114618114632_))
              (_K114616114629_ _octets114635_))
            (_E114615114624_)))))
  (define std/net/address#ip4-address->string
    (lambda (_ip4114610_)
      (if (std/net/address#ip4-address? _ip4114610_)
          (apply std/format#format
                 '"~a.~a.~a.~a"
                 (##u8vector->list _ip4114610_))
          (if (std/net/address#ip4-address-string? _ip4114610_)
              _ip4114610_
              (error '"Malformed ip4 address" _ip4114610_)))))
  (define std/net/address#ip6-address
    (lambda (_obj114608_)
      (if (std/net/address#ip6-address? _obj114608_)
          _obj114608_
          (if (std/net/address#ip6-address-string? _obj114608_)
              (std/net/address#string->ip6-address _obj114608_)
              (error '"Malformed ip6 address" _obj114608_)))))
  (define std/net/address#ip6-address?
    (lambda (_obj114606_)
      (if (##u8vector? _obj114606_)
          (##fx= (##u8vector-length _obj114606_) '16)
          '#f)))
  (define std/net/address#ip6-address-rx
    (std/pregexp#pregexp '"^[0-9a-fA-F:]+$"))
  (define std/net/address#ip6-address-string?
    (lambda (_obj114604_)
      (if (string? _obj114604_)
          (if (std/pregexp#pregexp-match
               std/net/address#ip6-address-rx
               _obj114604_)
              '#t
              '#f)
          '#f)))
  (define std/net/address#string->ip6-address
    (lambda (_str114491_)
      (letrec ((_hex-e114493_
                (lambda (_str114596_ _k114597_)
                  (let* ((_char114599_ (string-ref _str114596_ _k114597_))
                         (_$e114601_ (std/text/hex#unhex* _char114599_)))
                    (if _$e114601_
                        (values _$e114601_)
                        (error '"Malformed address; not a hex digit"
                               _str114596_
                               _char114599_)))))
               (_loop114494_
                (lambda (_rest114546_ _bytes114547_ _have-zeros114548_)
                  (let* ((_rest114549114557_ _rest114546_)
                         (_else114551114565_
                          (lambda ()
                            (_check114495_
                             (list->u8vector (reverse _bytes114547_)))))
                         (_K114553114584_
                          (lambda (_rest114568_ _hex114569_)
                            (let ((_$e114571_ (string-length _hex114569_)))
                              (if (eq? '0 _$e114571_)
                                  (if _have-zeros114548_
                                      (error '"Malformed address" _str114491_)
                                      (let* ((_count114574_
                                              (length _rest114568_))
                                             (_count114576_
                                              (##fx* (##fx- '8 _count114574_)
                                                     '2))
                                             (_count114578_
                                              (##fx- _count114576_
                                                     (length _bytes114547_)))
                                             (_g114680_
                                              (if (##fxnegative? _count114578_)
                                                  (error '"Malformed address; too many bits"
                                                         _str114491_)
                                                  '#!void))
                                             (_block114581_
                                              (make-list _count114578_ '0)))
                                        (_loop114494_
                                         _rest114568_
                                         (foldl1 cons
                                                 _bytes114547_
                                                 _block114581_)
                                         '#t)))
                                  (if (eq? '1 _$e114571_)
                                      (_loop114494_
                                       _rest114568_
                                       (cons (_hex-e114493_ _hex114569_ '0)
                                             (cons '0 _bytes114547_))
                                       _have-zeros114548_)
                                      (if (eq? '2 _$e114571_)
                                          (_loop114494_
                                           _rest114568_
                                           (cons (##fxior (##fxarithmetic-shift
                                                           (_hex-e114493_
                                                            _hex114569_
                                                            '0)
                                                           '4)
                                                          (_hex-e114493_
                                                           _hex114569_
                                                           '1))
                                                 (cons '0 _bytes114547_))
                                           _have-zeros114548_)
                                          (if (eq? '3 _$e114571_)
                                              (_loop114494_
                                               _rest114568_
                                               (cons (##fxior (##fxarithmetic-shift
                                                               (_hex-e114493_
                                                                _hex114569_
                                                                '1)
                                                               '4)
                                                              (_hex-e114493_
                                                               _hex114569_
                                                               '2))
                                                     (cons (_hex-e114493_
                                                            _hex114569_
                                                            '0)
                                                           _bytes114547_))
                                               _have-zeros114548_)
                                              (if (eq? '4 _$e114571_)
                                                  (_loop114494_
                                                   _rest114568_
                                                   (cons (##fxior (##fxarithmetic-shift
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           (_hex-e114493_ _hex114569_ '2)
                           '4)
                          (_hex-e114493_ _hex114569_ '3))
                 (cons (##fxior (##fxarithmetic-shift
                                 (_hex-e114493_ _hex114569_ '0)
                                 '4)
                                (_hex-e114493_ _hex114569_ '1))
                       _bytes114547_))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   _have-zeros114548_)
                                                  _hex114569_)))))))))
                    (if (##pair? _rest114549114557_)
                        (let ((_hd114554114587_ (##car _rest114549114557_))
                              (_tl114555114589_ (##cdr _rest114549114557_)))
                          (let* ((_hex114592_ _hd114554114587_)
                                 (_rest114594_ _tl114555114589_))
                            (_K114553114584_ _rest114594_ _hex114592_)))
                        (_else114551114565_)))))
               (_check114495_
                (lambda (_bytes114544_)
                  (if (##fx= (u8vector-length _bytes114544_) '16)
                      _bytes114544_
                      (if (##fx< (u8vector-length _bytes114544_) '16)
                          (error '"Malformed address; not enough bits"
                                 _str114491_
                                 _bytes114544_)
                          (error '"malformed address; too many bits"
                                 _str114491_
                                 _bytes114544_))))))
        (let* ((_hexes114497_ (string-split _str114491_ '#\:))
               (_hexes114498114508_ _hexes114497_)
               (_else114500114516_
                (lambda () (_loop114494_ _hexes114497_ '() '#f)))
               (_K114502114529_
                (lambda (_rest114519_)
                  (let* ((_count114521_ (length _rest114519_))
                         (_count114523_ (##fx* (##fx- '8 _count114521_) '2))
                         (_g114681_
                          (if (##fxnegative? _count114523_)
                              (error '"Malformed address; too many bits"
                                     _str114491_)
                              '#!void))
                         (_bytes114526_ (make-list _count114523_ '0)))
                    (_loop114494_ _rest114519_ _bytes114526_ '#t)))))
          (if (##pair? _hexes114498114508_)
              (let ((_hd114503114532_ (##car _hexes114498114508_))
                    (_tl114504114534_ (##cdr _hexes114498114508_)))
                (if (equal? _hd114503114532_ '"")
                    (if (##pair? _tl114504114534_)
                        (let ((_hd114505114537_ (##car _tl114504114534_))
                              (_tl114506114539_ (##cdr _tl114504114534_)))
                          (if (equal? _hd114505114537_ '"")
                              (let ((_rest114542_ _tl114506114539_))
                                (_K114502114529_ _rest114542_))
                              (_else114500114516_)))
                        (_else114500114516_))
                    (_else114500114516_)))
              (_else114500114516_))))))
  (define std/net/address#ip6-address->string
    (lambda (_ip6114256_)
      (letrec ((_compress-zeros114258_
                (lambda (_hexes114489_)
                  (_compress-leading-trailing114259_
                   (_compress114260_ _hexes114489_))))
               (_compress-leading-trailing114259_
                (lambda (_hexes114487_)
                  (if (equal? (car _hexes114487_) '"")
                      (cons '"" _hexes114487_)
                      (if (equal? (last _hexes114487_) '"")
                          (begin
                            (set-cdr! (last-pair _hexes114487_) '(""))
                            _hexes114487_)
                          _hexes114487_))))
               (_compress114260_
                (lambda (_hexes114425_)
                  (let* ((_hexes114426114440_ _hexes114425_)
                         (_else114429114448_ (lambda () '())))
                    (let ((_K114434114472_
                           (lambda (_rest114470_)
                             (cons '"" (_compress*114261_ _rest114470_))))
                          (_K114431114455_
                           (lambda (_rest114452_ _hd114453_)
                             (cons _hd114453_
                                   (_compress114260_ _rest114452_)))))
                      (if (##pair? _hexes114426114440_)
                          (let ((_tl114436114477_ (##cdr _hexes114426114440_))
                                (_hd114435114475_ (##car _hexes114426114440_)))
                            (if (equal? _hd114435114475_ '"0")
                                (if (##pair? _tl114436114477_)
                                    (let ((_tl114438114482_
                                           (##cdr _tl114436114477_))
                                          (_hd114437114480_
                                           (##car _tl114436114477_)))
                                      (if (equal? _hd114437114480_ '"0")
                                          (let ((_rest114485_
                                                 _tl114438114482_))
                                            (_K114434114472_ _rest114485_))
                                          (let ((_hd114463_ _hd114435114475_)
                                                (_rest114465_
                                                 _tl114436114477_))
                                            (_K114431114455_
                                             _rest114465_
                                             _hd114463_))))
                                    (let ((_hd114463_ _hd114435114475_)
                                          (_rest114465_ _tl114436114477_))
                                      (_K114431114455_
                                       _rest114465_
                                       _hd114463_)))
                                (let ((_hd114463_ _hd114435114475_)
                                      (_rest114465_ _tl114436114477_))
                                  (_K114431114455_ _rest114465_ _hd114463_))))
                          (_else114429114448_))))))
               (_compress*114261_
                (lambda (_hexes114393_)
                  (let* ((_hexes114394114402_ _hexes114393_)
                         (_else114396114410_ (lambda () _hexes114393_))
                         (_K114398114415_
                          (lambda (_rest114413_)
                            (_compress*114261_ _rest114413_))))
                    (if (##pair? _hexes114394114402_)
                        (let ((_hd114399114418_ (##car _hexes114394114402_))
                              (_tl114400114420_ (##cdr _hexes114394114402_)))
                          (if (equal? _hd114399114418_ '"0")
                              (let ((_rest114423_ _tl114400114420_))
                                (_compress*114261_ _rest114423_))
                              (_else114396114410_)))
                        (_else114396114410_))))))
        (let _lp114263_ ((_rest114265_ (u8vector->list _ip6114256_))
                         (_hexes114266_ '()))
          (let* ((_rest114267114277_ _rest114265_)
                 (_else114269114285_
                  (lambda ()
                    (string-join
                     (_compress-zeros114258_ (reverse _hexes114266_))
                     '#\:)))
                 (_K114271114374_
                  (lambda (_rest114288_ _b1114289_ _b0114290_)
                    (let ((_b0h114292_
                           (##fxand (##fxarithmetic-shift _b0114290_ '-4) '15))
                          (_b0l114293_ (##fxand _b0114290_ '15))
                          (_b1h114294_
                           (##fxand (##fxarithmetic-shift _b1114289_ '-4) '15))
                          (_b1l114295_ (##fxand _b1114289_ '15)))
                      (let ((_b0h114296114311_ _b0h114292_)
                            (_b0l114297114313_ _b0l114293_)
                            (_b1h114298114315_ _b1h114294_)
                            (_b1l114299114317_ _b1l114295_))
                        (let ((_else114304114325_
                               (lambda ()
                                 (_lp114263_
                                  _rest114288_
                                  (cons (string (std/text/hex#hex _b0h114292_)
                                                (std/text/hex#hex _b0l114293_)
                                                (std/text/hex#hex _b1h114294_)
                                                (std/text/hex#hex _b1l114295_))
                                        _hexes114266_)))))
                          (let ((_K114309114371_
                                 (lambda ()
                                   (_lp114263_
                                    _rest114288_
                                    (cons '"0" _hexes114266_))))
                                (_K114308114362_
                                 (lambda (_b1l114360_)
                                   (_lp114263_
                                    _rest114288_
                                    (cons (string (std/text/hex#hex
                                                   _b1l114360_))
                                          _hexes114266_))))
                                (_K114307114349_
                                 (lambda (_b1h114346_ _b1l114347_)
                                   (_lp114263_
                                    _rest114288_
                                    (cons (string (std/text/hex#hex
                                                   _b1h114346_)
                                                  (std/text/hex#hex
                                                   _b1l114347_))
                                          _hexes114266_))))
                                (_K114306114333_
                                 (lambda (_b0l114329_ _b1h114330_ _b1l114331_)
                                   (_lp114263_
                                    _rest114288_
                                    (cons (string (std/text/hex#hex
                                                   _b0l114329_)
                                                  (std/text/hex#hex
                                                   _b1h114330_)
                                                  (std/text/hex#hex
                                                   _b1l114331_))
                                          _hexes114266_)))))
                            (if (##eq? _b0h114296114311_ '0)
                                (if (##eq? _b0l114297114313_ '0)
                                    (if (##eq? _b1h114298114315_ '0)
                                        (if (##eq? _b1l114299114317_ '0)
                                            (_K114309114371_)
                                            (let ((_b1l114365_
                                                   _b1l114299114317_))
                                              (_K114308114362_ _b1l114365_)))
                                        (let ((_b1h114352_ _b1h114298114315_)
                                              (_b1l114354_ _b1l114299114317_))
                                          (_K114307114349_
                                           _b1h114352_
                                           _b1l114354_)))
                                    (let ((_b0l114336_ _b0l114297114313_)
                                          (_b1h114338_ _b1h114298114315_)
                                          (_b1l114340_ _b1l114299114317_))
                                      (_K114306114333_
                                       _b0l114336_
                                       _b1h114338_
                                       _b1l114340_)))
                                (_else114304114325_)))))))))
            (if (##pair? _rest114267114277_)
                (let ((_hd114272114377_ (##car _rest114267114277_))
                      (_tl114273114379_ (##cdr _rest114267114277_)))
                  (let ((_b0114382_ _hd114272114377_))
                    (if (##pair? _tl114273114379_)
                        (let ((_hd114274114384_ (##car _tl114273114379_))
                              (_tl114275114386_ (##cdr _tl114273114379_)))
                          (let* ((_b1114389_ _hd114274114384_)
                                 (_rest114391_ _tl114275114386_))
                            (_K114271114374_
                             _rest114391_
                             _b1114389_
                             _b0114382_)))
                        (_else114269114285_))))
                (_else114269114285_)))))))
  (define std/net/address#inet-address
    (lambda (_obj114254_)
      (if (std/net/address#inet-address? _obj114254_)
          (std/net/address#inet-address-normalize _obj114254_)
          (if (std/net/address#inet-address-string? _obj114254_)
              (std/net/address#string->inet-address _obj114254_)
              (error '"Malformed inet address" _obj114254_)))))
  (define std/net/address#inet-address-normalize
    (lambda (_addr114221_)
      (let* ((_addr114222114229_ _addr114221_)
             (_E114224114233_
              (lambda () (error '"No clause matching" _addr114222114229_)))
             (_K114225114242_
              (lambda (_port114236_ _host114237_)
                (if (or (std/net/address#ip4-address? _host114237_)
                        (std/net/address#ip6-address? _host114237_))
                    _addr114221_
                    (if (std/net/address#ip4-address-string? _host114237_)
                        (cons (std/net/address#string->ip4-address
                               _host114237_)
                              _port114236_)
                        (if (std/net/address#ip6-address-string? _host114237_)
                            (cons (std/net/address#string->ip6-address
                                   _host114237_)
                                  _port114236_)
                            _addr114221_))))))
        (if (##pair? _addr114222114229_)
            (let ((_hd114226114245_ (##car _addr114222114229_))
                  (_tl114227114247_ (##cdr _addr114222114229_)))
              (let* ((_host114250_ _hd114226114245_)
                     (_port114252_ _tl114227114247_))
                (_K114225114242_ _port114252_ _host114250_)))
            (_E114224114233_)))))
  (define std/net/address#inet-address?
    (lambda (_obj114186_)
      (let* ((_obj114187114195_ _obj114186_)
             (_else114189114203_ (lambda () '#f))
             (_K114191114209_
              (lambda (_port114206_ _host114207_)
                (if (std/net/address#inet-host-address? _host114207_)
                    (fixnum? _port114206_)
                    '#f))))
        (if (##pair? _obj114187114195_)
            (let ((_hd114192114212_ (##car _obj114187114195_))
                  (_tl114193114214_ (##cdr _obj114187114195_)))
              (let* ((_host114217_ _hd114192114212_)
                     (_port114219_ _tl114193114214_))
                (_K114191114209_ _port114219_ _host114217_)))
            (_else114189114203_)))))
  (define std/net/address#inet-address-string?
    (lambda (_obj114140_)
      (let ((_$e114142_
             (if (string? _obj114140_)
                 (std/net/address#inet-address-split__% _obj114140_ false)
                 '#f)))
        (if _$e114142_
            ((lambda (_e114144114146_)
               (let* ((_g114148114156_ _e114144114146_)
                      (_else114150114164_ (lambda () '#f))
                      (_K114152114173_
                       (lambda (_port114167_ _host114168_)
                         (let ((_$e114170_ (string-empty? _host114168_)))
                           (if _$e114170_
                               _$e114170_
                               (std/net/address#inet-host-address-string?
                                _host114168_))))))
                 (if (##fx= (if (##values? _g114148114156_)
                                (##vector-length _g114148114156_)
                                '1)
                            '2)
                     (let* ((_e114153114176_ (##vector-ref _g114148114156_ '0))
                            (_host114179_ _e114153114176_)
                            (_e114154114181_ (##vector-ref _g114148114156_ '1))
                            (_port114184_ _e114154114181_))
                       (_K114152114173_ _port114184_ _host114179_))
                     (_else114150114164_))))
             _$e114142_)
            '#f))))
  (define std/net/address#inet-address-split__%
    (lambda (_str114122_ _E114123_)
      (let ((_$e114125_ (string-rindex _str114122_ '#\:)))
        (if _$e114125_
            ((lambda (_ix114128_)
               (values (substring _str114122_ '0 _ix114128_)
                       (substring
                        _str114122_
                        (##fx+ _ix114128_ '1)
                        (string-length _str114122_))))
             _$e114125_)
            (_E114123_ '"Malformed address; no port separator" _str114122_)))))
  (define std/net/address#inet-address-split__0
    (lambda (_str114133_)
      (let ((_E114135_ error))
        (std/net/address#inet-address-split__% _str114133_ _E114135_))))
  (define std/net/address#inet-address-split
    (lambda _g114683_
      (let ((_g114682_ (length _g114683_)))
        (cond ((##fx= _g114682_ 1)
               (apply std/net/address#inet-address-split__0 _g114683_))
              ((##fx= _g114682_ 2)
               (apply std/net/address#inet-address-split__% _g114683_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/address#inet-address-split
                _g114683_))))))
  (define std/net/address#inet-host-address?
    (lambda (_obj114113_)
      (let ((_$e114115_ (std/net/address#ip4-address? _obj114113_)))
        (if _$e114115_
            _$e114115_
            (let ((_$e114118_ (std/net/address#ip6-address? _obj114113_)))
              (if _$e114118_
                  _$e114118_
                  (std/net/address#inet-host-address-string? _obj114113_)))))))
  (define std/net/address#inet-host-address-string?
    (lambda (_obj114105_)
      (let ((_$e114107_ (std/net/address#ip4-address-string? _obj114105_)))
        (if _$e114107_
            _$e114107_
            (let ((_$e114110_
                   (std/net/address#ip6-address-string? _obj114105_)))
              (if _$e114110_
                  _$e114110_
                  (std/net/address#inet-host-name? _obj114105_)))))))
  (define std/net/address#inet-host-name?
    (lambda (_obj114103_)
      (if (string? _obj114103_)
          (std/pregexp#pregexp-match
           std/net/address#inet-host-name-rx
           _obj114103_)
          '#f)))
  (define std/net/address#inet-host-name-rx
    (std/pregexp#pregexp
     '"^[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?)*$"))
  (define std/net/address#string->inet-address
    (lambda (_str114063_)
      (letrec ((_string->host114065_
                (lambda (_host114101_)
                  (if (std/net/address#ip4-address-string? _host114101_)
                      (std/net/address#string->ip4-address _host114101_)
                      (if (std/net/address#ip6-address-string? _host114101_)
                          (std/net/address#string->ip6-address _host114101_)
                          (if (std/net/address#inet-host-name? _host114101_)
                              _host114101_
                              (if (string-empty? _host114101_)
                                  '#u8(0 0 0 0)
                                  (error '"Malformed address; bad host"
                                         _str114063_
                                         _host114101_)))))))
               (_string->port114066_
                (lambda (_port114097_)
                  (let ((_port114099_ (string->number _port114097_)))
                    (if (and (fixnum? _port114099_)
                             (##fx<= '0 _port114099_ '65535))
                        _port114099_
                        (error '"Malformed address; bad port"
                               _str114063_
                               _port114099_))))))
        (let* ((_g114067114074_
                (std/net/address#inet-address-split__0 _str114063_))
               (_E114069114078_
                (lambda () (error '"No clause matching" _g114067114074_)))
               (_K114070114084_
                (lambda (_port114081_ _host114082_)
                  (cons (_string->host114065_ _host114082_)
                        (_string->port114066_ _port114081_)))))
          (if (##fx= (if (##values? _g114067114074_)
                         (##vector-length _g114067114074_)
                         '1)
                     '2)
              (let* ((_e114071114087_ (##vector-ref _g114067114074_ '0))
                     (_host114090_ _e114071114087_)
                     (_e114072114092_ (##vector-ref _g114067114074_ '1))
                     (_port114095_ _e114072114092_))
                (_K114070114084_ _port114095_ _host114090_))
              (_E114069114078_))))))
  (define std/net/address#inet-address->string
    (lambda (_obj114033_)
      (if (std/net/address#inet-address? _obj114033_)
          (let* ((_obj114034114041_ _obj114033_)
                 (_E114036114045_
                  (lambda () (error '"No clause matching" _obj114034114041_)))
                 (_K114037114051_
                  (lambda (_port114048_ _host114049_)
                    (std/format#format
                     '"~a:~a"
                     (std/net/address#inet-host-address->string _host114049_)
                     _port114048_))))
            (if (##pair? _obj114034114041_)
                (let ((_hd114038114054_ (##car _obj114034114041_))
                      (_tl114039114056_ (##cdr _obj114034114041_)))
                  (let* ((_host114059_ _hd114038114054_)
                         (_port114061_ _tl114039114056_))
                    (_K114037114051_ _port114061_ _host114059_)))
                (_E114036114045_)))
          (if (std/net/address#inet-address-string? _obj114033_)
              _obj114033_
              (error '"Malformed inet address")))))
  (define std/net/address#inet-host-address->string
    (lambda (_host114031_)
      (if (string? _host114031_)
          _host114031_
          (if (std/net/address#ip4-address? _host114031_)
              (std/net/address#ip4-address->string _host114031_)
              (if (std/net/address#ip6-address? _host114031_)
                  (std/net/address#ip6-address->string _host114031_)
                  (error '"Malformed inet host address" _host114031_))))))
  (define std/net/address#resolve-address
    (lambda (_addr113961_)
      (let* ((_addr113963_ (std/net/address#inet-address _addr113961_))
             (_addr113964113971_ _addr113963_)
             (_E113966113975_
              (lambda () (error '"No clause matching" _addr113964113971_)))
             (_K113967114019_
              (lambda (_port113978_ _host113979_)
                (if (or (std/net/address#ip4-address? _host113979_)
                        (std/net/address#ip6-address? _host113979_))
                    _addr113963_
                    (let* ((_info113984_ (host-info _host113979_))
                           (_g113985113993_ (host-info-addresses _info113984_))
                           (_else113987114001_
                            (lambda ()
                              (error '"Failed to resolve address"
                                     _addr113963_)))
                           (_K113989114007_
                            (lambda (_rest114004_ _ip114005_)
                              (cons _ip114005_ _port113978_))))
                      (if (##pair? _g113985113993_)
                          (let ((_hd113990114010_ (##car _g113985113993_))
                                (_tl113991114012_ (##cdr _g113985113993_)))
                            (let* ((_ip114015_ _hd113990114010_)
                                   (_rest114017_ _tl113991114012_))
                              (_K113989114007_ _rest114017_ _ip114015_)))
                          (_else113987114001_)))))))
        (if (##pair? _addr113964113971_)
            (let ((_hd113968114022_ (##car _addr113964113971_))
                  (_tl113969114024_ (##cdr _addr113964113971_)))
              (let* ((_host114027_ _hd113968114022_)
                     (_port114029_ _tl113969114024_))
                (_K113967114019_ _port114029_ _host114027_)))
            (_E113966113975_)))))
  (define std/net/address#resolved-address?
    (lambda (_obj113923_)
      (let* ((_obj113924113932_ _obj113923_)
             (_else113926113940_ (lambda () '#f))
             (_K113928113949_
              (lambda (_port113943_ _host113944_)
                (if (or (std/net/address#ip4-address? _host113944_)
                        (std/net/address#ip6-address? _host113944_))
                    (fixnum? _port113943_)
                    '#f))))
        (if (##pair? _obj113924113932_)
            (let ((_hd113929113952_ (##car _obj113924113932_))
                  (_tl113930113954_ (##cdr _obj113924113932_)))
              (let* ((_host113957_ _hd113929113952_)
                     (_port113959_ _tl113930113954_))
                (_K113928113949_ _port113959_ _host113957_)))
            (_else113926113940_))))))
