/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTypeToken;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.plugin.core.hover.AbstractDataTypeHover;
import ghidra.app.util.ToolTipUtils;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import javax.swing.JComponent;

public class DataTypeDecompilerHover
extends AbstractDataTypeHover
implements DecompilerHoverService {
    private static final String NAME = "Data Type Display";
    private static final String DESCRIPTION = "Show data type contents when hovering over a type name.";
    private static final int PRIORITY = 20;

    protected DataTypeDecompilerHover(PluginTool tool) {
        super(tool, 20);
    }

    public void initializeOptions() {
        this.options = this.tool.getOptions("Decompiler Popups");
        this.options.registerOption(NAME, (Object)true, null, DESCRIPTION);
        this.setOptions((Options)this.options, NAME);
        this.options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void setOptions(Options options, String optionName) {
        if (optionName.equals(NAME)) {
            this.enabled = options.getBoolean(NAME, true);
        }
    }

    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled || programLocation == null) {
            return null;
        }
        DataType dt = null;
        boolean hasInvalidStorage = false;
        if (field instanceof ClangTextField) {
            ClangToken token = ((ClangTextField)field).getToken(fieldLocation);
            if (token instanceof ClangTypeToken) {
                dt = ((ClangTypeToken)token).getDataType();
            }
            if (dt != null) {
                String toolTipText = ToolTipUtils.getToolTipText((DataType)dt);
                Object warningMsg = "";
                if (hasInvalidStorage) {
                    warningMsg = (String)warningMsg + "WARNING! Invalid Storage";
                }
                if (((String)warningMsg).length() != 0) {
                    String errorText = "<HTML><center><font color=\"red\">" + (String)warningMsg + "!</font></center><BR>";
                    toolTipText = toolTipText.replace("<HTML>", errorText);
                }
                return this.createTooltipComponent(toolTipText);
            }
        }
        return null;
    }
}

