/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.io.File;

public class DebugDecompilerAction
extends DockingAction {
    private final DecompilerController controller;

    public DebugDecompilerAction(String owner, DecompilerController controller) {
        super("Debug Function Decompilation", owner);
        this.controller = controller;
        this.setMenuBarData(new MenuData(new String[]{"Debug Function Decompilation"}, "xDebug"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            return true;
        }
        return this.controller.getFunction() != null;
    }

    public void actionPerformed(ActionContext context) {
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
            return;
        }
        DecompilerPanel parentComponent = this.controller.getDecompilerPanel();
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)parentComponent);
        fileChooser.setTitle("Please Choose Output File");
        fileChooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(new String[]{"xml"}, "XML Files"));
        File file = fileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        if (file.exists() && OptionDialog.showYesNoDialog((Component)parentComponent, (String)"Overwrite Existing File?", (String)"Do you want to overwrite the existing file?") == 2) {
            return;
        }
        this.controller.setStatusMessage("Dumping debug info to " + file.getAbsolutePath());
        this.controller.refreshDisplay(this.controller.getProgram(), this.controller.getLocation(), file);
    }
}

