/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.ActionDialog;
import docking.ComponentProvider;
import docking.DockingKeyBindingAction;
import docking.DockingWindowManager;
import docking.ExecutableKeyActionAdapter;
import docking.KeyBindingPrecedence;
import docking.action.DockingActionIf;
import ghidra.util.SystemUtilities;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;

public class MultipleKeyAction
extends DockingKeyBindingAction {
    private List<ActionData> actions = new ArrayList<ActionData>();
    private ActionDialog dialog;

    public MultipleKeyAction(DockingWindowManager winMgr, ComponentProvider provider, DockingActionIf action, KeyStroke keyStroke) {
        super(winMgr, action, keyStroke);
        this.addAction(provider, action);
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public void addAction(ComponentProvider provider, DockingActionIf action) {
        for (ActionData actionData : this.actions) {
            if (!actionData.action.equals(action)) continue;
            return;
        }
        KeyStroke keyBinding = action.getKeyBinding();
        if (!this.keyStroke.equals(keyBinding)) {
            throw new IllegalArgumentException("KeyStrokes don't match - was: " + this.keyStroke + " new: " + keyBinding);
        }
        this.actions.add(new ActionData(action, provider));
    }

    public void removeAction(DockingActionIf action) {
        Iterator<ActionData> iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            ActionData actionData = iterator.next();
            if (actionData.action != action) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public synchronized void setEnabled(boolean newValue) {
        if (newValue != this.enabled) {
            boolean oldValue = this.enabled;
            this.enabled = newValue;
            this.firePropertyChange("enabled", oldValue, newValue);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ComponentProvider localProvider = this.winMgr.getActiveComponentProvider();
        ActionContext localContext = this.getLocalContext(localProvider);
        localContext.setSource(event.getSource());
        ActionContext globalContext = this.winMgr.getGlobalContext();
        List<ExecutableKeyActionAdapter> list = this.getValidContextActions(localContext, globalContext);
        if (this.ignoreActionWhileMenuShowing()) {
            return;
        }
        JFrame rootFrame = this.winMgr.getRootFrame();
        if (list.size() > 1) {
            if (this.dialog == null) {
                this.dialog = new ActionDialog(MultipleKeyAction.parseKeyStroke(this.keyStroke), list);
            } else {
                this.dialog.setActionList(list);
            }
            SystemUtilities.runSwingLater(() -> DockingWindowManager.showDialog(this.dialog));
        } else if (list.size() == 1) {
            ExecutableKeyActionAdapter actionProxy = list.get(0);
            this.winMgr.setStatusText("");
            actionProxy.execute();
        } else {
            String name = (String)this.getValue("Name");
            this.winMgr.setStatusText("Action (" + name + ") not valid in this context!");
            rootFrame.getToolkit().beep();
        }
    }

    private boolean ignoreActionWhileMenuShowing() {
        if (this.getKeyBindingPrecedence() == KeyBindingPrecedence.ReservedActionsLevel) {
            return false;
        }
        MenuSelectionManager menuManager = MenuSelectionManager.defaultManager();
        return menuManager.getSelectedPath().length != 0;
    }

    private List<ExecutableKeyActionAdapter> getValidContextActions(ActionContext localContext, ActionContext globalContext) {
        ArrayList<ExecutableKeyActionAdapter> list = new ArrayList<ExecutableKeyActionAdapter>();
        boolean hasLocalActionsForKeyBinding = false;
        for (ActionData actionData : this.actions) {
            if (!actionData.isMyProvider(localContext.getComponentProvider())) continue;
            hasLocalActionsForKeyBinding = true;
            if (!actionData.action.isEnabledForContext(localContext)) continue;
            list.add(new ExecutableKeyActionAdapter(actionData.action, localContext));
        }
        if (hasLocalActionsForKeyBinding) {
            return list;
        }
        for (ActionData actionData : this.actions) {
            if (!actionData.isGlobalAction()) continue;
            if (actionData.action.isValidContext(localContext)) {
                if (!actionData.action.isEnabledForContext(localContext)) continue;
                list.add(new ExecutableKeyActionAdapter(actionData.action, localContext));
                continue;
            }
            if (!actionData.action.isValidGlobalContext(globalContext) || !actionData.action.isEnabledForContext(globalContext)) continue;
            list.add(new ExecutableKeyActionAdapter(actionData.action, globalContext));
        }
        return list;
    }

    @Override
    public boolean isReservedKeybindingPrecedence() {
        return false;
    }

    @Override
    public KeyBindingPrecedence getKeyBindingPrecedence() {
        ActionContext globalContext;
        ComponentProvider localProvider = this.winMgr.getActiveComponentProvider();
        ActionContext localContext = this.getLocalContext(localProvider);
        List<ExecutableKeyActionAdapter> validActions = this.getValidContextActions(localContext, globalContext = this.winMgr.getGlobalContext());
        if (validActions.isEmpty()) {
            return null;
        }
        if (validActions.size() != 1) {
            return KeyBindingPrecedence.DefaultLevel;
        }
        ExecutableKeyActionAdapter actionProxy = validActions.get(0);
        DockingActionIf action = actionProxy.getAction();
        return action.getKeyBindingData().getKeyBindingPrecedence();
    }

    public List<DockingActionIf> getActions() {
        ArrayList<DockingActionIf> list = new ArrayList<DockingActionIf>(this.actions.size());
        for (ActionData actionData : this.actions) {
            list.add(actionData.action);
        }
        return list;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [\n\t" + this.getKeyBindingsAsString() + "\n]";
    }

    private String getKeyBindingsAsString() {
        StringBuilder buildy = new StringBuilder();
        for (ActionData data : this.actions) {
            buildy.append(data.action.toString()).append("\n\t");
        }
        if (this.actions.size() > 0) {
            buildy.delete(buildy.length() - 2, buildy.length());
        }
        return buildy.toString();
    }

    class ActionData {
        DockingActionIf action;
        ComponentProvider provider;

        ActionData(DockingActionIf action, ComponentProvider provider) {
            this.action = action;
            this.provider = provider;
        }

        boolean isGlobalAction() {
            return this.provider == null;
        }

        boolean isMyProvider(ComponentProvider otherProvider) {
            return this.provider == otherProvider;
        }
    }
}

