/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import docking.event.mouse.GMouseListenerAdapter;
import docking.widgets.filechooser.DirectoryListModel;
import docking.widgets.filechooser.FileListCellRenderer;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserDirectoryModelIf;
import docking.widgets.list.GList;
import ghidra.util.exception.AssertException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class DirectoryList
extends GList<File>
implements GhidraFileChooserDirectoryModelIf {
    private GhidraFileChooser chooser;
    private DirectoryListModel model;
    private JLabel listEditorLabel;
    private JTextField listEditorText;
    private JPanel listEditor;
    private File editedFile;

    DirectoryList(GhidraFileChooser chooser, DirectoryListModel model) {
        super(model);
        this.chooser = chooser;
        this.model = model;
        this.build();
    }

    private void build() {
        this.setLayoutOrientation(1);
        this.setCellRenderer(new FileListCellRenderer(this.chooser));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DirectoryList.this.listEditor.setVisible(false);
                DirectoryList.this.requestFocus();
            }
        });
        this.addMouseListener(new GMouseListenerAdapter(){

            @Override
            public boolean shouldConsume(MouseEvent e) {
                return e.isPopupTrigger() && DirectoryList.this.isEditing();
            }

            @Override
            public void popupTriggered(MouseEvent e) {
                DirectoryList.this.maybeSelectItem(e);
            }

            @Override
            public void doubleClickTriggered(MouseEvent e) {
                DirectoryList.this.handleDoubleClick();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() != 10) {
                    return;
                }
                e.consume();
                int[] selectedIndices = DirectoryList.this.getSelectedIndices();
                if (selectedIndices.length == 0) {
                    DirectoryList.this.chooser.okCallback();
                    return;
                }
                if (selectedIndices.length > 1) {
                    DirectoryList.this.chooser.okCallback();
                    return;
                }
                File file = DirectoryList.this.model.getFile(selectedIndices[0]);
                if (DirectoryList.this.chooser.getModel().isDirectory(file)) {
                    DirectoryList.this.chooser.setCurrentDirectory(file);
                } else {
                    DirectoryList.this.chooser.userChoseFile(file);
                }
            }
        });
        this.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateChooserForSelection();
        });
        this.listEditorLabel = new JLabel();
        this.listEditorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int index = DirectoryList.this.locationToIndex(new Point(DirectoryList.this.listEditor.getX(), DirectoryList.this.listEditor.getY()));
                File file = DirectoryList.this.model.getFile(index);
                if (e.getClickCount() == 2) {
                    if (DirectoryList.this.chooser.getModel().isDirectory(file)) {
                        DirectoryList.this.chooser.setCurrentDirectory(file);
                    }
                    DirectoryList.this.cancelListEdit();
                }
            }
        });
        this.listEditorText = new JTextField();
        this.listEditorText.setName("LIST_EDITOR_FIELD");
        this.listEditorText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DirectoryList.this.cancelListEdit();
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DirectoryList.this.listEditor.setVisible(false);
                    e.consume();
                } else if (e.getKeyCode() == 10) {
                    DirectoryList.this.stopListEdit();
                    e.consume();
                }
            }
        });
        this.listEditorText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DirectoryList.this.stopListEdit();
            }
        });
        this.listEditor = new JPanel(new BorderLayout());
        this.listEditor.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.listEditor.add((Component)this.listEditorLabel, "West");
        this.listEditor.add((Component)this.listEditorText, "Center");
        this.listEditor.setBackground(Color.WHITE);
        this.listEditorText.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.add(this.listEditor);
    }

    private void maybeSelectItem(MouseEvent e) {
        Point point = e.getPoint();
        int index = this.locationToIndex(point);
        if (index < 0) {
            return;
        }
        this.setSelectedIndex(index);
    }

    private void handleDoubleClick() {
        int[] selectedIndices;
        ArrayList<File> selectedFiles = new ArrayList<File>();
        for (int i : selectedIndices = this.getSelectedIndices()) {
            selectedFiles.add(this.model.getFile(i));
        }
        if (selectedFiles.size() == 0 || selectedFiles.size() > 1) {
            return;
        }
        File file = (File)selectedFiles.get(0);
        if (this.chooser.getModel().isDirectory(file)) {
            this.chooser.setCurrentDirectory(file);
        } else {
            this.chooser.userChoseFile(file);
        }
    }

    private void updateChooserForSelection() {
        int[] selectedIndices;
        ArrayList<File> selectedFiles = new ArrayList<File>();
        for (int index : selectedIndices = this.getSelectedIndices()) {
            selectedFiles.add(this.model.getFile(index));
        }
        this.chooser.userSelectedFiles(selectedFiles);
    }

    @Override
    public int[] getSelectedRows() {
        return this.getSelectedIndices();
    }

    @Override
    public File getSelectedFile() {
        int index = this.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        return this.model.getFile(index);
    }

    @Override
    public File getFile(int row) {
        return this.model.getFile(row);
    }

    @Override
    public void edit() {
        int index = this.getSelectedIndex();
        this.editListCell(index);
    }

    @Override
    public void setSelectedFile(File file) {
        File selectedFile;
        int[] selectedIndices = this.getSelectedIndices();
        if (selectedIndices.length == 1 && (selectedFile = this.model.getFile(selectedIndices[0])).equals(file)) {
            return;
        }
        for (int i = 0; i < this.model.getSize(); ++i) {
            File aFile = this.model.getFile(i);
            if (aFile == null || !aFile.equals(file)) continue;
            this.setSelectedIndex(i);
            Rectangle rect = this.getCellBounds(i, i);
            this.scrollRectToVisible(rect);
            return;
        }
    }

    void setSelectedFiles(Iterable<File> files) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (File f : files) {
            indexes.add(this.model.indexOfFile(f));
        }
        int[] indices = new int[indexes.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)indexes.get(i);
        }
        this.setSelectedIndices(indices);
    }

    private boolean isEditing() {
        return this.editedFile != null;
    }

    void editListCell(int index) {
        if (index == -1) {
            return;
        }
        this.add(this.listEditor);
        Rectangle r = this.getCellBounds(index, index);
        this.editedFile = this.model.getFile(index);
        if (this.editedFile == null) {
            throw new AssertException("Unexpected condition - asked to edit file that does not exist in model");
        }
        this.listEditor.setBounds(r.x, r.y, r.width, r.height);
        this.listEditor.setVisible(true);
        this.listEditorLabel.setIcon(this.chooser.getModel().getIcon(this.editedFile));
        this.listEditorText.setText(this.editedFile.getName());
        this.listEditorText.requestFocus();
        this.listEditorText.selectAll();
    }

    void cancelListEdit() {
        this.editedFile = null;
        this.remove(this.listEditor);
        this.listEditor.setVisible(false);
        this.listEditorLabel.setIcon(null);
        this.listEditorText.setText("");
        this.repaint();
    }

    void stopListEdit() {
        if (!this.isEditing()) {
            return;
        }
        File editedFileCopy = this.editedFile;
        int index = this.model.indexOfFile(editedFileCopy);
        if (index < 0) {
            throw new AssertException("Somehow editing file not in our model.");
        }
        File dest = new File(editedFileCopy.getParentFile(), this.listEditorText.getText());
        this.cancelListEdit();
        if (this.chooser.getModel().renameFile(editedFileCopy, dest)) {
            this.model.set(index, dest);
            this.chooser.setSelectedFileAndUpdateDisplay(dest);
        } else {
            this.chooser.setStatusText("Unable to rename " + editedFileCopy);
        }
    }

    JTextField getListEditorText() {
        return this.listEditorText;
    }
}

