/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.DockingWindowManager;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableColumnModel;
import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.TableModelWrapper;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public final class GTableToCSV {
    static final String TITLE = "Export to CSV";

    public static final void writeCSV(File file, GTable table) {
        ConvertTask task = new ConvertTask(file, table, table.getModel());
        new TaskLauncher(task, table, 0);
    }

    public static final void writeCSVUsingColunns(File file, GTable table, List<Integer> selectedColumns) {
        ConvertTask task = new ConvertTask(file, table, table.getModel(), selectedColumns);
        new TaskLauncher(task, table, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeCSV(File file, GTable table, GTableColumnModel columnModel, TableModel model, List<Integer> columns, TaskMonitor monitor) throws IOException {
        List<TableColumn> tableColumns = null;
        tableColumns = columns.isEmpty() ? GTableToCSV.getVisibleColumnsInOrder(table, monitor) : GTableToCSV.getTableColumnsByIndex(table, columns);
        try (PrintWriter writer = new PrintWriter(file);){
            GTableToCSV.writeColumnNames(writer, tableColumns, model, monitor);
            GTableToCSV.writeNewLine(writer);
            GTableToCSV.writeModel(writer, table, tableColumns, model, monitor);
        }
    }

    private static List<TableColumn> getVisibleColumnsInOrder(JTable table, TaskMonitor monitor) {
        TableColumnModel columnModel = table.getColumnModel();
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        for (int columnIndex = 0; columnIndex < table.getColumnCount() && !monitor.isCancelled(); ++columnIndex) {
            TableColumn column = columnModel.getColumn(columnIndex);
            columns.add(column);
        }
        return columns;
    }

    private static List<TableColumn> getTableColumnsByIndex(JTable table, List<Integer> columnIndices) {
        TableColumnModel columnModel = table.getColumnModel();
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        for (Integer index : columnIndices) {
            TableColumn column = columnModel.getColumn(index);
            columns.add(column);
        }
        return columns;
    }

    private static void writeModel(PrintWriter writer, GTable table, List<TableColumn> tableColumns, TableModel model, TaskMonitor monitor) {
        int[] selectedRows = table.getSelectedRows();
        if (selectedRows.length == 0) {
            GTableToCSV.writeAllModelData(writer, table, model, monitor);
            return;
        }
        monitor.setMessage("Writing model...");
        monitor.initialize((long)selectedRows.length);
        int columnCount = tableColumns.size();
        for (int i = 0; i < selectedRows.length && !monitor.isCancelled(); ++i) {
            monitor.setProgress((long)i);
            for (int j = 0; j < columnCount && !monitor.isCancelled(); ++j) {
                TableColumn tableColumn = tableColumns.get(j);
                int column = table.convertColumnIndexToView(tableColumn.getModelIndex());
                int row = GTableToCSV.getModelRow(selectedRows[i], model);
                row = selectedRows[i];
                String value = GTableToCSV.getColumnValue(table, model, row, column);
                if (value == null) {
                    value = "";
                }
                value = HTMLUtilities.fromHTML((String)value);
                GTableToCSV.writeField(writer, value, monitor);
                if (j >= columnCount - 1) continue;
                GTableToCSV.writeFieldSeparator(writer);
            }
            GTableToCSV.writeNewLine(writer);
        }
    }

    private static String getColumnValue(JTable table, TableModel model, int row, int column) {
        String[] result = new String[1];
        try {
            SwingUtilities.invokeAndWait(() -> {
                result[0] = GTableToCSV.getTableCellValue(table, model, row, column);
            });
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        return result[0];
    }

    private static String getTableCellValue(JTable table, TableModel model, int row, int column) {
        TableColumnModel columnModel;
        TableColumn tableColumn;
        int modelIndex;
        Object value;
        TableCellRenderer renderer = table.getCellRenderer(row, column);
        Component component = renderer.getTableCellRendererComponent(table, value = model.getValueAt(row, modelIndex = (tableColumn = (columnModel = table.getColumnModel()).getColumn(column)).getModelIndex()), false, false, row, column);
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            return GTableToCSV.getTextForLabel(label);
        }
        String text = GTableToCSV.lookForTextInsideOfComponent(component);
        if (text != null) {
            return text;
        }
        return value == null ? "" : value.toString();
    }

    private static String getTextForLabel(JLabel label) {
        String text = label.getText();
        if (text != null) {
            return text;
        }
        Icon icon = label.getIcon();
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getDescription();
        }
        return null;
    }

    private static String lookForTextInsideOfComponent(Component component) {
        Component[] components;
        if (!(component instanceof Container)) {
            return null;
        }
        Container container = (Container)component;
        for (Component child : components = container.getComponents()) {
            if (child instanceof JLabel) {
                JLabel label = (JLabel)child;
                String text = label.getText();
                if (text == null) continue;
                return text;
            }
            if (!(child instanceof JTextComponent)) continue;
            JTextComponent textComponent = (JTextComponent)child;
            return textComponent.getText();
        }
        return null;
    }

    private static int getModelRow(int viewRow, TableModel model) {
        if (model instanceof RowObjectFilterModel) {
            RowObjectFilterModel threadedModel = (RowObjectFilterModel)model;
            return threadedModel.getModelRow(viewRow);
        }
        if (model instanceof TableModelWrapper) {
            TableModelWrapper wrapper = (TableModelWrapper)model;
            return wrapper.getModelRow(viewRow);
        }
        return viewRow;
    }

    private static void writeAllModelData(PrintWriter writer, JTable table, TableModel model, TaskMonitor monitor) {
        monitor.setMessage("Writing model...");
        monitor.initialize((long)model.getRowCount());
        int columnCount = table.getColumnCount();
        for (int row = 0; row < model.getRowCount() && !monitor.isCancelled(); ++row) {
            monitor.setProgress((long)row);
            for (int col = 0; col < columnCount && !monitor.isCancelled(); ++col) {
                String value = GTableToCSV.getColumnValue(table, model, row, col);
                if (value == null) {
                    value = "";
                }
                GTableToCSV.writeField(writer, value, monitor);
                if (col >= columnCount - 1) continue;
                GTableToCSV.writeFieldSeparator(writer);
            }
            GTableToCSV.writeNewLine(writer);
        }
    }

    private static void writeColumnNames(PrintWriter writer, List<TableColumn> columns, TableModel model, TaskMonitor monitor) {
        monitor.setMessage("Writing columns...");
        monitor.initialize((long)columns.size());
        for (int i = 0; i < columns.size() && !monitor.isCancelled(); ++i) {
            monitor.setProgress((long)i);
            TableColumn column = columns.get(i);
            int modelIndex = column.getModelIndex();
            GTableToCSV.writeField(writer, model.getColumnName(modelIndex), monitor);
            if (i >= columns.size() - 1) continue;
            GTableToCSV.writeFieldSeparator(writer);
        }
    }

    private static void writeNewLine(PrintWriter writer) {
        writer.print('\n');
    }

    private static void writeFieldSeparator(PrintWriter writer) {
        writer.print(',');
    }

    private static final void writeField(PrintWriter writer, String fieldValue, TaskMonitor monitor) {
        writer.print("\"");
        for (int i = 0; i < fieldValue.length() && !monitor.isCancelled(); ++i) {
            if (fieldValue.charAt(i) == '\"') {
                writer.print("\"");
                continue;
            }
            writer.print(fieldValue.charAt(i));
        }
        writer.print("\"");
    }

    private static class ConvertTask
    extends Task {
        private final GTable table;
        private TableModel model;
        private GTableColumnModel columnModel;
        private File file;
        private List<Integer> columns = new ArrayList<Integer>();

        ConvertTask(File file, GTable table, TableModel model) {
            super(GTableToCSV.TITLE, true, true, true);
            this.file = file;
            this.table = table;
            this.columnModel = (GTableColumnModel)table.getColumnModel();
            this.model = model;
        }

        ConvertTask(File file, GTable table, TableModel model, List<Integer> columns) {
            super(GTableToCSV.TITLE, true, true, true);
            this.file = file;
            this.table = table;
            this.columns = columns;
            this.columnModel = (GTableColumnModel)table.getColumnModel();
            this.model = model;
        }

        public void run(TaskMonitor monitor) {
            try {
                GTableToCSV.writeCSV(this.file, this.table, this.columnModel, this.model, this.columns, monitor);
            }
            catch (IOException e) {
                Msg.error((Object)GTable.class.getName(), (Object)e.getMessage());
            }
            DockingWindowManager manager = DockingWindowManager.getInstance(this.table);
            if (manager != null) {
                manager.setStatusText("Finished writing CSV data");
            }
        }
    }
}

