/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.columnfilter;

import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableFilter;
import docking.widgets.table.columnfilter.ColumnConstraintSet;
import docking.widgets.table.columnfilter.LogicOperation;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.TableFilterContext;
import ghidra.framework.options.SaveState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jdom.Element;

public class ColumnBasedTableFilter<R>
implements TableFilter<R> {
    private final RowObjectTableModel<R> model;
    private String name;
    private List<ColumnConstraintSet<R, ?>> constraintSets = new ArrayList();
    private TableFilterContext tableFilterContext = this::getDataSource;
    private OrList orList;

    public ColumnBasedTableFilter(RowObjectTableModel<R> model) {
        this.model = model;
        this.name = null;
    }

    public ColumnBasedTableFilter<R> copy() {
        ColumnBasedTableFilter<R> newFilter = new ColumnBasedTableFilter<R>(this.model);
        newFilter.constraintSets.addAll(this.constraintSets);
        newFilter.name = this.name;
        return newFilter;
    }

    @Override
    public boolean acceptsRow(R rowObject) {
        if (this.orList == null) {
            this.orList = this.buildOrList();
        }
        return this.orList.acceptsRow(rowObject);
    }

    private OrList buildOrList() {
        OrList localOrList = new OrList();
        if (this.constraintSets.isEmpty()) {
            return localOrList;
        }
        AndList currentAndList = new AndList();
        localOrList.addAndList(currentAndList);
        currentAndList.addConstraintSet(this.constraintSets.get(0));
        for (int i = 1; i < this.constraintSets.size(); ++i) {
            ColumnConstraintSet<R, ?> columnConstraintSet = this.constraintSets.get(i);
            if (columnConstraintSet.getLogicOperation() == LogicOperation.OR) {
                currentAndList = new AndList();
                localOrList.addAndList(currentAndList);
            }
            currentAndList.addConstraintSet(columnConstraintSet);
        }
        return localOrList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public <T> void addConstraintSet(LogicOperation logicalOp, int columnIndex, List<ColumnConstraint<T>> constraints) {
        this.constraintSets.add(new ColumnConstraintSet<R, T>(this.model, columnIndex, constraints, logicalOp));
        this.orList = null;
    }

    @Override
    public boolean isSubFilterOf(TableFilter<?> tableFilter) {
        return this.equals(tableFilter);
    }

    @Override
    public boolean hasColumnFilter(int columnModelIndex) {
        for (ColumnConstraintSet<R, ?> constraintSet : this.constraintSets) {
            if (constraintSet.getColumnModelIndex() != columnModelIndex) continue;
            return true;
        }
        return false;
    }

    public List<ColumnConstraintSet<R, ?>> getConstraintSets() {
        return this.constraintSets;
    }

    public SaveState save() {
        SaveState saveState = new SaveState("COLUMN_TABLE_FILTER");
        saveState.putString("NAME", this.name);
        saveState.putInt("COLUMN_FILTER_COUNT", this.constraintSets.size());
        for (int i = 0; i < this.constraintSets.size(); ++i) {
            ColumnConstraintSet<R, ?> constraintSet = this.constraintSets.get(i);
            SaveState save = constraintSet.save();
            saveState.putXmlElement("COLUMN_FILTER_" + i, save.saveToXml());
        }
        return saveState;
    }

    public <T> void restore(SaveState saveState, Object dataSource) {
        this.constraintSets.clear();
        this.name = saveState.getString("NAME", "");
        int columnCount = saveState.getInt("COLUMN_FILTER_COUNT", 0);
        for (int i = 0; i < columnCount; ++i) {
            Element xmlElement = saveState.getXmlElement("COLUMN_FILTER_" + i);
            SaveState childState = new SaveState(xmlElement);
            this.constraintSets.add(new ColumnConstraintSet(this.model, childState, dataSource));
        }
    }

    public String getHtmlRepresentation() {
        return this.getHtmlRepresentation(this.constraintSets);
    }

    public String getToolTip(int columnIndex) {
        List<ColumnConstraintSet<R, ?>> filtered = this.constraintSets.stream().filter(cf -> cf.getColumnModelIndex() == columnIndex).collect(Collectors.toList());
        if (filtered.isEmpty()) {
            return null;
        }
        return this.getHtmlRepresentation(filtered);
    }

    private String getHtmlRepresentation(List<ColumnConstraintSet<R, ?>> filters) {
        StringBuilder buf = new StringBuilder();
        buf.append("<table valign=top cellspacing=5 cellpadding=0 >");
        buf.append("<tr>");
        buf.append("<td></td><td>");
        buf.append(filters.get(0).getHtmlRepresentation());
        buf.append("</td></tr>");
        for (int i = 1; i < filters.size(); ++i) {
            buf.append("<tr><td style=\"color:gray\"> " + filters.get(i).getLogicOperation() + "&nbsp;</td><td>");
            buf.append(filters.get(i).getHtmlRepresentation());
            buf.append("</td></tr>");
        }
        buf.append("</table>");
        buf.append("</html>");
        return buf.toString();
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.model.getClass(), this.name, this.constraintSets);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnBasedTableFilter other = (ColumnBasedTableFilter)obj;
        if (this.model != other.model) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.constraintSets, other.constraintSets);
    }

    public boolean isEquivalent(ColumnBasedTableFilter<?> other) {
        if (other == null) {
            return false;
        }
        if (this.model != other.model) {
            return false;
        }
        return Objects.equals(this.constraintSets, other.constraintSets);
    }

    private Object getDataSource() {
        if (this.model instanceof GDynamicColumnTableModel) {
            return ((GDynamicColumnTableModel)this.model).getDataSource();
        }
        return null;
    }

    public boolean isSaved() {
        return this.name != null;
    }

    private class OrList {
        private List<AndList> list = new ArrayList<AndList>();

        private OrList() {
        }

        void addAndList(AndList andList) {
            this.list.add(andList);
        }

        boolean acceptsRow(R rowObject) {
            for (AndList andList : this.list) {
                if (!andList.acceptsRow(rowObject)) continue;
                return true;
            }
            return false;
        }
    }

    private class AndList {
        private List<ColumnConstraintSet<R, ?>> list = new ArrayList();

        private AndList() {
        }

        void addConstraintSet(ColumnConstraintSet<R, ?> constraintSet) {
            this.list.add(constraintSet);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        boolean acceptsRow(R rowObject) {
            for (ColumnConstraintSet constraintSet : this.list) {
                if (constraintSet.accepts(rowObject, ColumnBasedTableFilter.this.tableFilterContext)) continue;
                return false;
            }
            return true;
        }
    }
}

