/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction35c
extends InstructionWithReference
implements FiveRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regCount;
    private byte regA;
    private byte regD;
    private byte regE;
    private byte regF;
    private byte regG;

    public Instruction35c(Opcode opcode, int regCount, byte regD, byte regE, byte regF, byte regG, byte regA, Item referencedItem) {
        super(opcode, referencedItem);
        if (regCount > 5) {
            throw new RuntimeException("regCount cannot be greater than 5");
        }
        if (regD >= 16 || regE >= 16 || regF >= 16 || regG >= 16 || regA >= 16) {
            throw new RuntimeException("All register args must fit in 4 bits");
        }
        Instruction35c.checkItem(opcode, referencedItem, regCount);
        this.regCount = (byte)regCount;
        this.regA = regA;
        this.regD = regD;
        this.regE = regE;
        this.regF = regF;
        this.regG = regG;
    }

    protected Instruction35c(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
        super(dexFile, opcode, buffer, bufferIndex);
        this.regCount = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 1]);
        this.regA = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 1]);
        this.regD = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 4]);
        this.regE = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 4]);
        this.regF = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 5]);
        this.regG = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 5]);
        if (this.getRegCount() > 5) {
            throw new RuntimeException("regCount cannot be greater than 5");
        }
        Instruction35c.checkItem(opcode, this.getReferencedItem(), this.getRegCount());
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        if (this.getReferencedItem().getIndex() > 65535) {
            if (this.opcode.hasJumboOpcode()) {
                throw new RuntimeException(String.format("%s index is too large. Use the %s instruction instead.", this.opcode.referenceType.name(), this.opcode.getJumboOpcode().name));
            }
            throw new RuntimeException(String.format("%s index is too large.", this.opcode.referenceType.name()));
        }
        out.writeByte(this.opcode.value);
        out.writeByte(this.regCount << 4 | this.regA);
        out.writeShort(this.getReferencedItem().getIndex());
        out.writeByte(this.regE << 4 | this.regD);
        out.writeByte(this.regG << 4 | this.regF);
    }

    @Override
    public Format getFormat() {
        return Format.Format35c;
    }

    @Override
    public int getRegCount() {
        return this.regCount;
    }

    @Override
    public byte getRegisterA() {
        return this.regA;
    }

    @Override
    public byte getRegisterD() {
        return this.regD;
    }

    @Override
    public byte getRegisterE() {
        return this.regE;
    }

    @Override
    public byte getRegisterF() {
        return this.regF;
    }

    @Override
    public byte getRegisterG() {
        return this.regG;
    }

    private static void checkItem(Opcode opcode, Item item, int regCount) {
        if (opcode == Opcode.FILLED_NEW_ARRAY) {
            String type = ((TypeIdItem)item).getTypeDescriptor();
            if (type.charAt(0) != '[') {
                throw new RuntimeException("The type must be an array type");
            }
            if (type.charAt(1) == 'J' || type.charAt(1) == 'D') {
                throw new RuntimeException("The type cannot be an array of longs or doubles");
            }
        } else if (opcode.value >= Opcode.INVOKE_VIRTUAL.value && opcode.value <= Opcode.INVOKE_INTERFACE.value || opcode == Opcode.INVOKE_DIRECT_EMPTY) {
            MethodIdItem methodIdItem = (MethodIdItem)item;
            int parameterRegisterCount = methodIdItem.getPrototype().getParameterRegisterCount();
            if (opcode != Opcode.INVOKE_STATIC) {
                ++parameterRegisterCount;
            }
            if (parameterRegisterCount != regCount) {
                throw new RuntimeException("regCount does not match the number of arguments of the method");
            }
        }
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction35c(dexFile, opcode, buffer, bufferIndex);
        }
    }
}

