/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.fs;

import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.fs.BaseHFSAllocationFileView;
import org.catacombae.hfsexplorer.fs.BaseHFSFileSystemView;
import org.catacombae.hfsexplorer.fs.ImplHFSPlusAllocationFileView;
import org.catacombae.hfsexplorer.io.ForkFilter;
import org.catacombae.hfsexplorer.io.ReadableRandomAccessSubstream;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTHeaderNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTHeaderRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTNodeDescriptor;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogIndexNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogKey;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogLeafNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogString;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentIndexNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentKey;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentLeafNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSForkData;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSForkType;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.hfsexplorer.types.hfsplus.BTHeaderRec;
import org.catacombae.hfsexplorer.types.hfsplus.BTNodeDescriptor;
import org.catacombae.hfsexplorer.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogKey;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentKey;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusVolumeHeader;
import org.catacombae.hfsexplorer.types.hfsplus.HFSUniStr255;
import org.catacombae.hfsexplorer.types.hfsplus.JournalInfoBlock;
import org.catacombae.io.Readable;
import org.catacombae.io.ReadableRandomAccessStream;

public class ImplHFSPlusFileSystemView
extends BaseHFSFileSystemView {
    private static final CommonHFSCatalogString EMPTY_STRING = CommonHFSCatalogString.createHFSPlus(new HFSUniStr255(""));
    protected static final BaseHFSFileSystemView.CatalogOperations HFS_PLUS_OPERATIONS = new BaseHFSFileSystemView.CatalogOperations(){

        public CommonHFSCatalogIndexNode newCatalogIndexNode(byte[] data, int offset, int nodeSize, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogIndexNode.createHFSPlus(data, offset, nodeSize);
        }

        public CommonHFSCatalogKey newCatalogKey(CommonHFSCatalogNodeID nodeID, CommonHFSCatalogString searchString, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogKey.create(new HFSPlusCatalogKey(new HFSCatalogNodeID((int)nodeID.toLong()), new HFSUniStr255(searchString.getStructBytes(), 0)));
        }

        public CommonHFSCatalogLeafNode newCatalogLeafNode(byte[] data, int offset, int nodeSize, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogLeafNode.createHFSPlus(data, offset, nodeSize);
        }

        public CommonHFSCatalogLeafRecord newCatalogLeafRecord(byte[] data, int offset, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogLeafRecord.createHFSPlus(data, offset, data.length - offset);
        }
    };

    public ImplHFSPlusFileSystemView(ReadableRandomAccessStream hfsFile, long fsOffset, boolean cachingEnabled) {
        this(hfsFile, fileReadOffset, HFS_PLUS_OPERATIONS, cachingEnabled);
    }

    protected ImplHFSPlusFileSystemView(ReadableRandomAccessStream hfsFile, long fsOffset, BaseHFSFileSystemView.CatalogOperations catOps, boolean cachingEnabled) {
        super(hfsFile, fsOffset, catOps, cachingEnabled);
    }

    public HFSPlusVolumeHeader getHFSPlusVolumeHeader() {
        byte[] currentBlock = new byte[512];
        this.hfsFile.readFrom(this.fsOffset + 1024L, currentBlock);
        return new HFSPlusVolumeHeader(currentBlock);
    }

    public CommonHFSVolumeHeader getVolumeHeader() {
        return CommonHFSVolumeHeader.create(this.getHFSPlusVolumeHeader());
    }

    protected CommonBTNodeDescriptor getNodeDescriptor(Readable rd) {
        byte[] data = new byte[BTNodeDescriptor.length()];
        rd.readFully(data);
        BTNodeDescriptor btnd = new BTNodeDescriptor(data, 0);
        return CommonBTNodeDescriptor.create(btnd);
    }

    protected CommonBTHeaderRecord getHeaderRecord(Readable rd) {
        byte[] data = new byte[BTHeaderRec.length()];
        rd.readFully(data);
        BTHeaderRec bthr = new BTHeaderRec(data, 0);
        return CommonBTHeaderRecord.create(bthr);
    }

    protected CommonBTNodeDescriptor createCommonBTNodeDescriptor(byte[] currentNodeData, int offset) {
        BTNodeDescriptor btnd = new BTNodeDescriptor(currentNodeData, offset);
        return CommonBTNodeDescriptor.create(btnd);
    }

    protected CommonHFSExtentIndexNode createCommonHFSExtentIndexNode(byte[] currentNodeData, int offset, int nodeSize) {
        return CommonHFSExtentIndexNode.createHFSPlus(currentNodeData, offset, nodeSize);
    }

    protected CommonHFSExtentLeafNode createCommonHFSExtentLeafNode(byte[] currentNodeData, int offset, int nodeSize) {
        return CommonHFSExtentLeafNode.createHFSPlus(currentNodeData, offset, nodeSize);
    }

    protected CommonHFSExtentKey createCommonHFSExtentKey(CommonHFSForkType forkType, CommonHFSCatalogNodeID fileID, int startBlock) {
        byte forkTypeByte;
        switch (forkType) {
            case DATA_FORK: {
                forkTypeByte = 0;
                break;
            }
            case RESOURCE_FORK: {
                forkTypeByte = -1;
                break;
            }
            default: {
                throw new RuntimeException("Invalid fork type");
            }
        }
        HFSPlusExtentKey key = new HFSPlusExtentKey(forkTypeByte, new HFSCatalogNodeID((int)fileID.toLong()), startBlock);
        return CommonHFSExtentKey.create(key);
    }

    protected CommonHFSCatalogNodeID getCommonHFSCatalogNodeID(CommonHFSCatalogNodeID.ReservedID requestedNodeID) {
        return CommonHFSCatalogNodeID.getHFSPlusReservedID(requestedNodeID);
    }

    public JournalInfoBlock getJournalInfoBlock() {
        HFSPlusVolumeHeader vh = this.getHFSPlusVolumeHeader();
        if (vh.getAttributeVolumeJournaled()) {
            long blockNumber = Util.unsign((int)vh.getJournalInfoBlock());
            byte[] data = new byte[JournalInfoBlock.getStructSize()];
            this.hfsFile.readFullyFrom(this.fsOffset + blockNumber * (long)vh.getBlockSize(), data);
            return new JournalInfoBlock(data, 0);
        }
        return null;
    }

    public CommonHFSCatalogString encodeString(String str) {
        return CommonHFSCatalogString.HFSPlusImplementation.createHFSPlus(new HFSUniStr255(str));
    }

    public String decodeString(CommonHFSCatalogString str) {
        if (str instanceof CommonHFSCatalogString.HFSPlusImplementation) {
            CommonHFSCatalogString.HFSPlusImplementation hStr = (CommonHFSCatalogString.HFSPlusImplementation)str;
            return new String(hStr.getInternal().getUnicode());
        }
        throw new RuntimeException("Invalid string type: " + str.getClass());
    }

    protected CommonBTHeaderNode createCommonBTHeaderNode(byte[] currentNodeData, int offset, int nodeSize) {
        return CommonBTHeaderNode.createHFSPlus(currentNodeData, offset, nodeSize);
    }

    public BaseHFSAllocationFileView getAllocationFileView() {
        HFSPlusVolumeHeader vh = this.getHFSPlusVolumeHeader();
        CommonHFSForkData allocationFileFork = CommonHFSForkData.create(vh.getAllocationFile());
        CommonHFSExtentDescriptor[] extDescriptors = this.getAllExtentDescriptors(CommonHFSCatalogNodeID.getHFSPlusReservedID(CommonHFSCatalogNodeID.ReservedID.ALLOCATION_FILE), allocationFileFork, CommonHFSForkType.DATA_FORK);
        ForkFilter allocationFileStream = new ForkFilter(allocationFileFork, extDescriptors, (ReadableRandomAccessStream)new ReadableRandomAccessSubstream(this.hfsFile), this.fsOffset, Util.unsign((int)vh.getBlockSize()), 0L);
        return new ImplHFSPlusAllocationFileView(this, (ReadableRandomAccessStream)allocationFileStream);
    }

    public CommonHFSCatalogString getEmptyString() {
        return EMPTY_STRING;
    }
}

