/*
 * Decompiled with CFR 0.152.
 */
package generic.algorithms;

import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class LCS<T> {
    private int[][] c;

    protected LCS() {
    }

    protected abstract int lengthOfX();

    protected abstract int lengthOfY();

    protected abstract T valueOfX(int var1);

    protected abstract T valueOfY(int var1);

    protected abstract boolean matches(T var1, T var2);

    private void calculateLCS(TaskMonitor monitor) throws CancelledException {
        int i;
        if (this.c != null) {
            return;
        }
        int[][] tempC = new int[this.lengthOfX() + 1][];
        monitor.setMessage("Calculating LCS...");
        monitor.initialize((long)tempC.length);
        for (i = 0; i < tempC.length; ++i) {
            tempC[i] = new int[this.lengthOfY() + 1];
        }
        for (i = 1; i < tempC.length; ++i) {
            monitor.checkCanceled();
            for (int j = 1; j < tempC[i].length; ++j) {
                tempC[i][j] = this.matches(this.valueOfX(i), this.valueOfY(j)) ? tempC[i - 1][j - 1] + 1 : Math.max(tempC[i][j - 1], tempC[i - 1][j]);
            }
            monitor.incrementProgress(1L);
        }
        this.c = tempC;
    }

    public List<T> getLCS() {
        try {
            return this.getLCS(TaskMonitorAdapter.DUMMY_MONITOR);
        }
        catch (CancelledException cancelledException) {
            return null;
        }
    }

    public List<T> getLCS(TaskMonitor monitor) throws CancelledException {
        this.calculateLCS(monitor);
        return this.getLCSHelperIterative(this.lengthOfX(), this.lengthOfY());
    }

    private List<T> getLCSHelperIterative(int i, int j) {
        ArrayList<T> result = new ArrayList<T>();
        while (i > 0 && j > 0) {
            if (this.c[i][j] == this.c[i - 1][j - 1] + 1 && this.matches(this.valueOfX(i), this.valueOfY(j))) {
                result.add(0, this.valueOfX(i));
                --i;
                --j;
                continue;
            }
            if (this.c[i][j] == this.c[i - 1][j]) {
                --i;
                continue;
            }
            --j;
        }
        return result;
    }
}

