/*
 * Decompiled with CFR 0.152.
 */
package generic.cache;

import generic.cache.Factory;
import ghidra.util.datastruct.LRUMap;

public class FixedSizeMRUCachingFactory<K, V>
implements Factory<K, V> {
    private LRUMap<K, V> cache;
    private Factory<K, V> delegate;

    public FixedSizeMRUCachingFactory(Factory<K, V> factory, int size) {
        this.delegate = factory;
        this.cache = new LRUMap(size);
    }

    @Override
    public V get(K key) {
        V value = this.cache.get(key);
        if (value != null) {
            return value;
        }
        value = this.delegate.get(key);
        this.cache.put(key, value);
        return value;
    }
}

