/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class VariableRowHeightGridLayout
implements LayoutManager {
    private int vgap;
    private int hgap;
    private final int columnCount;

    public VariableRowHeightGridLayout(int columnCount) {
        this(0, 0, columnCount);
    }

    public VariableRowHeightGridLayout(int vgap, int hgap, int columnCount) {
        this.vgap = vgap;
        this.hgap = hgap;
        if (columnCount <= 0) {
            columnCount = 1;
        }
        this.columnCount = columnCount;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int componentCount = parent.getComponentCount();
        int rowCount = (componentCount + (this.columnCount - 1)) / this.columnCount;
        Insets insets = parent.getInsets();
        Dimension d = new Dimension(0, 0);
        int totalComponentHeight = 0;
        for (int i = 0; i < rowCount; ++i) {
            totalComponentHeight += this.getRowHeight(parent, i);
        }
        int totalColumns = Math.min(this.columnCount, componentCount);
        int totalComponentWidth = this.getPreferredColumnWidth(parent) * totalColumns;
        d.width = totalComponentWidth + this.hgap * (this.columnCount - 1) + insets.left + insets.right;
        d.height = totalComponentHeight + this.vgap * (rowCount - 1) + insets.top + insets.bottom;
        return d;
    }

    private int getRowHeight(Container parent, int row) {
        int rowHeight = 0;
        int componentCount = parent.getComponentCount();
        for (int i = 0; i < this.columnCount; ++i) {
            int ordinal = row * this.columnCount + i;
            if (ordinal >= componentCount) {
                return rowHeight;
            }
            Component component = parent.getComponent(ordinal);
            Dimension d = component.getPreferredSize();
            rowHeight = Math.max(rowHeight, d.height);
        }
        return rowHeight;
    }

    private int getPreferredColumnWidth(Container parent) {
        int width = 0;
        int componentCount = parent.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component component = parent.getComponent(i);
            Dimension d = component.getPreferredSize();
            width = Math.max(width, d.width);
        }
        return width;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        int componentCount = parent.getComponentCount();
        int rowCount = (componentCount + (this.columnCount - 1)) / this.columnCount;
        Dimension d = parent.getSize();
        Insets insets = parent.getInsets();
        int width = d.width - (insets.left + insets.right);
        int totalColumns = Math.min(this.columnCount, componentCount);
        int availableColumnWidth = (width - (this.columnCount - 1) * this.hgap) / totalColumns;
        int columnWidth = this.getColumnWidth(parent, availableColumnWidth);
        int y = insets.top;
        for (int i = 0; i < rowCount; ++i) {
            int ordinal;
            int x = insets.left;
            int rowHeight = this.getRowHeight(parent, i);
            for (int j = 0; j < this.columnCount && (ordinal = i * this.columnCount + j) < componentCount; ++j) {
                Component component = parent.getComponent(ordinal);
                component.setBounds(x, y, columnWidth, rowHeight);
                x += columnWidth + this.hgap;
            }
            y += rowHeight + this.vgap;
        }
    }

    private int getColumnWidth(Container parent, int availableColumnWidth) {
        return availableColumnWidth;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.out.println("Error loading L&F: " + exc);
        }
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        JPanel panel = new JPanel(new VariableRowHeightGridLayout(1, 5, 15));
        panel.add(new JLabel("One", 4));
        panel.add(new JTextField());
        panel.add(new JLabel("Two", 4));
        panel.add(new JTextField());
        panel.add(new JLabel("Three", 4));
        panel.add(new JTextField());
        panel.setBorder(BorderFactory.createEmptyBorder(8, 25, 10, 10));
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
    }
}

