/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import generic.concurrent.ConcurrentListenerSet;
import ghidra.util.Issue;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.IssueListener;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.Set;

public class TaskMonitorSplitter {
    public static int MONITOR_SIZE = 100000;

    public static TaskMonitor[] splitTaskMonitor(TaskMonitor monitor, int n) {
        TaskMonitor[] subMonitors = new TaskMonitor[n];
        monitor.initialize((long)MONITOR_SIZE);
        double subSize = (double)MONITOR_SIZE / (double)n;
        HashSet<SubTaskMonitor> sharedSet = new HashSet<SubTaskMonitor>();
        for (int i = 0; i < n; ++i) {
            subMonitors[i] = new SubTaskMonitor(monitor, subSize, sharedSet);
        }
        return subMonitors;
    }

    static class SubTaskMonitor
    implements TaskMonitor,
    CancelledListener {
        private long max = 100L;
        private long progress = 0L;
        private TaskMonitor parent;
        private ConcurrentListenerSet<CancelledListener> listeners;
        private int parentProgress;
        private double subSize;

        public SubTaskMonitor(TaskMonitor parent, double subSize, Set<SubTaskMonitor> notDoneYetSet) {
            this.parent = parent;
            this.subSize = subSize;
            notDoneYetSet.add(this);
            parent.addCancelledListener((CancelledListener)this);
        }

        public void addCancelledListener(CancelledListener listener) {
            if (this.listeners == null) {
                this.listeners = new ConcurrentListenerSet();
            }
            this.listeners.add(listener);
        }

        public void cancel() {
            this.parent.cancel();
        }

        public void checkCanceled() throws CancelledException {
            this.parent.checkCanceled();
        }

        public void clearCanceled() {
            throw new UnsupportedOperationException();
        }

        public long getMaximum() {
            return this.max;
        }

        public long getProgress() {
            return this.progress;
        }

        public void incrementProgress(long incrementAmount) {
            this.progress += incrementAmount;
            this.normalizeProgress();
            this.updateParent();
        }

        private void updateParent() {
            int newParentProgress = this.max == 0L ? 0 : (int)((double)this.progress * this.subSize / (double)this.max);
            this.parent.incrementProgress((long)(newParentProgress - this.parentProgress));
            this.parentProgress = newParentProgress;
        }

        private void normalizeProgress() {
            if (this.progress > this.max) {
                this.progress = this.max;
            }
        }

        public boolean isCancelEnabled() {
            return this.parent.isCancelEnabled();
        }

        public boolean isCancelled() {
            return this.parent.isCancelled();
        }

        public void removeCancelledListener(CancelledListener listener) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }

        public void setCancelEnabled(boolean enable) {
            this.parent.setCancelEnabled(enable);
        }

        public void setShowProgressValue(boolean showProgressValue) {
            this.parent.setShowProgressValue(showProgressValue);
        }

        public void setIndeterminate(boolean indeterminate) {
            this.parent.setIndeterminate(indeterminate);
        }

        public void initialize(long newMax) {
            this.setMaximum(newMax);
            this.setProgress(0L);
        }

        public void setMaximum(long newMax) {
            this.max = newMax;
            this.normalizeProgress();
            this.updateParent();
        }

        public void setMessage(String message) {
            this.parent.setMessage(message);
        }

        public void setProgress(long value) {
            this.progress = value;
            this.normalizeProgress();
            this.updateParent();
        }

        public void cancelled() {
            this.notifyListeners();
        }

        private void notifyListeners() {
            if (this.listeners == null) {
                return;
            }
            for (CancelledListener listener : this.listeners) {
                listener.cancelled();
            }
        }

        public void addIssueListener(IssueListener listener) {
            this.parent.addIssueListener(listener);
        }

        public void removeIssueListener(IssueListener listener) {
            this.parent.removeIssueListener(listener);
        }

        public void reportIssue(Issue issue) {
            this.parent.reportIssue(issue);
        }
    }
}

