/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;

class NamePanel
extends JPanel {
    private JRadioButton keepOtherRB;
    private JRadioButton keepMyRB;
    private JRadioButton newTreeRB;
    private JRadioButton originalRB;
    private ButtonGroup group;
    private ChangeListener listener;

    NamePanel(ChangeListener listener) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Resolve Tree Name Conflict"));
        this.listener = listener;
        this.create();
    }

    void setNames(String name1, String name2, String origName) {
        this.keepOtherRB.setText("Use name '" + name1 + "' (Latest)");
        this.keepMyRB.setText("Use name '" + name2 + "' (Checked Out)");
        this.newTreeRB.setText("Add new tree named '" + name2 + "'");
        this.originalRB.setText("Use name '" + origName + "' (Original)");
        this.group.remove(this.keepOtherRB);
        this.group.remove(this.keepMyRB);
        this.group.remove(this.newTreeRB);
        this.group.remove(this.originalRB);
        this.keepOtherRB.setSelected(false);
        this.keepMyRB.setSelected(false);
        this.newTreeRB.setSelected(false);
        this.originalRB.setSelected(false);
        this.addToButtonGroup();
    }

    int getSelectedOption() {
        if (this.keepOtherRB.isSelected()) {
            return 0;
        }
        if (this.keepMyRB.isSelected()) {
            return 1;
        }
        if (this.newTreeRB.isSelected()) {
            return 2;
        }
        if (this.originalRB.isSelected()) {
            return 4;
        }
        return -1;
    }

    private void create() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.keepOtherRB = new JRadioButton("Keep 'Other' Name");
        this.keepMyRB = new JRadioButton("Keep 'My' Name");
        this.newTreeRB = new JRadioButton("Add New Tree");
        this.originalRB = new JRadioButton("Use Original Name");
        this.keepOtherRB.setName("Latest");
        this.keepMyRB.setName("Checked Out");
        this.newTreeRB.setName("Add New");
        this.originalRB.setName("Original");
        this.group = new ButtonGroup();
        this.addToButtonGroup();
        JPanel rbPanel = new JPanel();
        rbPanel.setLayout(new BoxLayout(rbPanel, 1));
        rbPanel.add(this.keepOtherRB);
        rbPanel.add(this.keepMyRB);
        rbPanel.add(this.newTreeRB);
        rbPanel.add(this.originalRB);
        panel.add((Component)rbPanel, "Center");
        this.add(panel);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (NamePanel.this.listener != null) {
                    NamePanel.this.listener.stateChanged(null);
                }
            }
        };
        this.keepOtherRB.addItemListener(itemListener);
        this.keepMyRB.addItemListener(itemListener);
        this.newTreeRB.addItemListener(itemListener);
        this.originalRB.addItemListener(itemListener);
    }

    private void addToButtonGroup() {
        this.group.add(this.keepOtherRB);
        this.group.add(this.keepMyRB);
        this.group.add(this.newTreeRB);
        this.group.add(this.originalRB);
    }
}

