/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.dialogs.NumberInputDialog;
import ghidra.app.cmd.data.CreateArrayCmd;
import ghidra.app.cmd.data.CreateArrayInStructureCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.data.DataPlugin;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.DummyKeyBindingsOptionsAction;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.InteriorSelection;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import javax.swing.KeyStroke;

class CreateArrayAction
extends DockingAction
implements OptionsChangeListener {
    private static final KeyStroke DEFAULT_KEY_STROKE = KeyStroke.getKeyStroke(91, 0);
    private static final String[] CREATE_ARRAY_POPUP_MENU = new String[]{"Data", "Create Array..."};
    private DataPlugin plugin;

    public CreateArrayAction(DataPlugin plugin) {
        super("Define Array", plugin.getName(), false);
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(CREATE_ARRAY_POPUP_MENU, "BasicData"));
        this.setEnabled(true);
        this.initializeKeybinding();
    }

    private void initializeKeybinding() {
        PluginTool tool = this.plugin.getTool();
        DummyKeyBindingsOptionsAction dummyKeybindingsAction = new DummyKeyBindingsOptionsAction(this.getName(), DEFAULT_KEY_STROKE);
        tool.addAction((DockingActionIf)dummyKeybindingsAction);
        ToolOptions options = tool.getOptions("Key Bindings");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        KeyStroke keyStroke = options.getKeyStroke(dummyKeybindingsAction.getFullName(), DEFAULT_KEY_STROKE);
        if (!DEFAULT_KEY_STROKE.equals(keyStroke)) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        } else {
            this.setKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    public void actionPerformed(ActionContext context) {
        ListingActionContext programActionContext = (ListingActionContext)context.getContextObject();
        Program program = programActionContext.getProgram();
        ProgramLocation loc = programActionContext.getLocation();
        ProgramSelection sel = programActionContext.getSelection();
        if (sel != null && !sel.isEmpty()) {
            InteriorSelection interiorSel = sel.getInteriorSelection();
            if (interiorSel != null) {
                this.createArrayInStructure(program, interiorSel);
            } else {
                this.createArrayFromSelection(program, sel);
            }
        } else {
            int[] compPath = loc.getComponentPath();
            if (compPath != null && compPath.length > 0) {
                this.createArrayInStructure(program, loc.getAddress(), compPath);
            } else {
                this.createArrayAtAddress(program, loc.getAddress());
            }
        }
    }

    private void createArrayInStructure(Program program, Address addr, int[] compPath) {
        PluginTool tool = this.plugin.getTool();
        Data data = program.getListing().getDataContaining(addr);
        Data comp = null;
        if (data != null) {
            comp = data.getComponent(compPath);
        }
        if (comp == null) {
            tool.setStatusInfo("Create Array Failed! No data at " + addr);
            return;
        }
        DataType dt = comp.getDataType();
        DataType parentDataType = comp.getParent().getBaseDataType();
        if (!(parentDataType instanceof Structure)) {
            tool.setStatusInfo("Cannot create array here");
            return;
        }
        Structure struct = (Structure)parentDataType;
        int maxElements = this.getMaxElements(struct, comp.getComponentIndex(), dt);
        int maxNoConflictElements = this.getMaxNoConflictElements(struct, comp.getComponentIndex(), dt);
        int numElements = this.getNumElements(dt, maxNoConflictElements, maxElements);
        CreateArrayInStructureCmd cmd = new CreateArrayInStructureCmd(addr, numElements, dt, compPath);
        if (!tool.execute((Command)cmd, (DomainObject)program)) {
            tool.setStatusInfo(cmd.getStatusMsg());
        }
    }

    private void createArrayInStructure(Program program, InteriorSelection sel) {
        PluginTool tool = this.plugin.getTool();
        ProgramLocation from = sel.getFrom();
        Data data = program.getListing().getDataContaining(from.getAddress());
        Data comp = null;
        if (data != null) {
            comp = data.getComponent(from.getComponentPath());
        }
        if (comp == null) {
            tool.setStatusInfo("Create Array Failed! No data at " + from.getAddress());
            return;
        }
        DataType dt = comp.getDataType();
        DataType parentDataType = comp.getParent().getBaseDataType();
        if (!(parentDataType instanceof Structure)) {
            tool.setStatusInfo("Cannot create array here");
            return;
        }
        int length = sel.getByteLength();
        int numElements = length / dt.getLength();
        CreateArrayInStructureCmd cmd = new CreateArrayInStructureCmd(from.getAddress(), numElements, dt, from.getComponentPath());
        if (!tool.execute((Command)cmd, (DomainObject)program)) {
            tool.setStatusInfo(cmd.getStatusMsg());
        }
    }

    private int getMaxNoConflictElements(Structure struct, int index, DataType dt) {
        DataTypeComponent dtc;
        DataType dataType;
        int n = struct.getNumComponents();
        int length = 0;
        while (index < n && ((dataType = (dtc = struct.getComponent(index++)).getDataType()) == DataType.DEFAULT || dataType == dt)) {
            length += dtc.getLength();
        }
        return length / dt.getLength();
    }

    private int getMaxElements(Structure struct, int index, DataType dt) {
        int n = struct.getNumComponents();
        int length = 0;
        while (index < n) {
            DataTypeComponent dtc = struct.getComponent(index++);
            length += dtc.getLength();
        }
        return length / dt.getLength();
    }

    private void createArrayAtAddress(Program program, Address addr) {
        int maxElements;
        int length;
        int maxNoConflictElements;
        PluginTool tool = this.plugin.getTool();
        Data data = program.getListing().getDataAt(addr);
        if (data == null) {
            tool.setStatusInfo("Create Array Failed! No data at " + addr);
            return;
        }
        DataType dt = data.getDataType();
        int numElements = this.getNumElements(dt, maxNoConflictElements = this.getMaxElementsThatFit(program, addr, length = data.getLength()), maxElements = this.getMaxElementsIgnoreExisting(program, addr, length));
        if (numElements == Integer.MIN_VALUE) {
            return;
        }
        CreateArrayCmd cmd = new CreateArrayCmd(addr, numElements, dt, length);
        if (!tool.execute((Command)cmd, (DomainObject)program)) {
            tool.setStatusInfo(cmd.getStatusMsg());
        }
    }

    private void createArrayFromSelection(Program program, ProgramSelection sel) {
        PluginTool tool = this.plugin.getTool();
        AddressRange range = sel.getFirstRange();
        Address addr = sel.getMinAddress();
        Data data = program.getListing().getDataAt(addr);
        if (data == null) {
            tool.setStatusInfo("Create Array Failed! No data at " + addr);
            return;
        }
        DataType dt = data.getDataType();
        int dtLength = data.getLength();
        int length = (int)range.getLength();
        int numElements = length / dtLength;
        CreateArrayCmd cmd = new CreateArrayCmd(addr, numElements, dt, dtLength);
        if (!tool.execute((Command)cmd, (DomainObject)program)) {
            tool.setStatusInfo(cmd.getStatusMsg());
        }
    }

    private int getNumElements(DataType dt, int maxNoConflictElements, int maxElements) {
        int result;
        NumberInputDialog numberInputDialog = new NumberInputDialog("Create " + dt.getName() + "[]", "Enter number of array elements (1 - " + maxElements + ") :", Integer.valueOf(maxNoConflictElements), 1, maxElements, false);
        if (maxNoConflictElements < maxElements) {
            numberInputDialog.setDefaultMessage("Entering more than " + maxNoConflictElements + " will overwrite existing data");
        }
        if (!numberInputDialog.show()) {
            return Integer.MIN_VALUE;
        }
        int value = numberInputDialog.getValue();
        if (value > maxNoConflictElements && (result = OptionDialog.showYesNoDialog(null, (String)"Overwrite Existing Data?", (String)"Existing data will be overridden if you create this array.\nAre you sure you want to continue?")) != 1) {
            return Integer.MIN_VALUE;
        }
        return value;
    }

    private int getMaxElementsThatFit(Program program, Address addr, int elementSize) {
        int length;
        Address dataAddr;
        Data data;
        Address instrAddr;
        MemoryBlock block = program.getMemory().getBlock(addr);
        if (block == null) {
            return 0;
        }
        Address maxAddr = block.getEnd();
        Instruction instr = program.getListing().getInstructionAfter(addr);
        if (instr != null && (instrAddr = instr.getMinAddress()).compareTo((Object)maxAddr) < 0) {
            maxAddr = instrAddr.subtract(1L);
        }
        if ((data = DataUtilities.getNextNonUndefinedDataAfter((Program)program, (Address)addr, (Address)maxAddr)) != null && (dataAddr = data.getMinAddress()).compareTo((Object)maxAddr) < 0) {
            maxAddr = dataAddr.subtract(1L);
        }
        if ((length = (int)maxAddr.subtract(addr) + 1) < 0) {
            return 0;
        }
        return length / elementSize;
    }

    private int getMaxElementsIgnoreExisting(Program program, Address addr, int elementSize) {
        int length;
        Memory asv = program.getMemory();
        AddressRange range = asv.getRangeContaining(addr);
        if (range == null) {
            return 0;
        }
        Address maxAddress = range.getMaxAddress();
        Instruction instructionAfter = program.getListing().getInstructionAfter(addr);
        if (instructionAfter != null && maxAddress.compareTo((Object)instructionAfter.getAddress()) > 0) {
            maxAddress = instructionAfter.getAddress().previous();
        }
        if ((length = (int)maxAddress.subtract(addr) + 1) < 0) {
            return 0;
        }
        return length / elementSize;
    }

    public boolean isEnabledForContext(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (contextObject instanceof ListingActionContext) {
            return this.plugin.isCreateDataAllowed((ListingActionContext)contextObject);
        }
        return false;
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        KeyStroke keyStroke = (KeyStroke)newValue;
        if (optionName.startsWith(this.getName())) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }
}

