/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.util.HelpLocation;

public class IncludeDataTypesInFilterAction
extends ToggleDockingAction {
    private final DataTypesProvider provider;

    public IncludeDataTypesInFilterAction(DataTypeManagerPlugin plugin, DataTypesProvider provider) {
        super("Include Data Members in Filter", plugin.getName());
        this.provider = provider;
        this.setMenuBarData(new MenuData(new String[]{"Include Data Members in Filter"}, null, "VeryLast", -1, "3"));
        this.setDescription("Selected indicates to include member names and data types in filter operations.");
        this.setEnabled(true);
        this.setSelected(false);
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Filter"));
    }

    public void setSelected(boolean newValue) {
        super.setSelected(newValue);
        this.provider.setIncludeDataTypeMembersInFilterCallback(newValue);
    }
}

