/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.framework.options.DummyKeyBindingsOptionsAction;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;
import javax.swing.KeyStroke;

class DataAction
extends ListingContextAction
implements OptionsChangeListener {
    private final String group;
    protected DataType dataType;
    protected FunctionPlugin plugin;
    private String actionName;
    private DummyKeyBindingsOptionsAction dummyKeybindingsAction;

    public DataAction(DataType dataType, FunctionPlugin plugin) {
        this("Define " + dataType.getDisplayName(), "Function", dataType, plugin);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "DataType"));
    }

    public DataAction(String name, String group, DataType dataType, FunctionPlugin plugin) {
        super(name, plugin.getName(), false);
        this.actionName = name;
        this.group = group;
        this.plugin = plugin;
        this.dataType = dataType;
        this.setPopupMenu(plugin.getDataActionMenuName(null), true);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "DataType"));
        this.initializeKeybinding();
    }

    private void initializeKeybinding() {
        PluginTool tool = this.plugin.getTool();
        this.dummyKeybindingsAction = new DummyKeyBindingsOptionsAction(this.actionName, this.getDefaultKeyStroke());
        tool.addAction((DockingActionIf)this.dummyKeybindingsAction);
        ToolOptions options = tool.getOptions("Key Bindings");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        KeyStroke keyStroke = options.getKeyStroke(this.dummyKeybindingsAction.getFullName(), this.getDefaultKeyStroke());
        this.initKeyStroke(keyStroke);
    }

    protected KeyStroke getDefaultKeyStroke() {
        return null;
    }

    protected void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
    }

    protected DockingAction getDummyKeyBindingAction() {
        return this.dummyKeybindingsAction;
    }

    void setPopupMenu(String name, boolean isSignatureAction) {
        this.setPopupMenuData(new MenuData(new String[]{"Set Data Type", this.dataType.getDisplayName()}, this.group));
    }

    public void dispose() {
        this.dataType = null;
        this.plugin = null;
        super.dispose();
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.createData(this.dataType, context, true);
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        ProgramLocation location = context.getLocation();
        if (this.plugin.isValidDataLocation(location)) {
            this.setPopupMenu(this.plugin.getDataActionMenuName(location), true);
            return true;
        }
        if (location instanceof VariableLocation) {
            this.setPopupMenu(this.plugin.getDataActionMenuName(location), false);
            return true;
        }
        return false;
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        KeyStroke keyStroke = (KeyStroke)newValue;
        if (optionName.startsWith(this.actionName)) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }
}

