/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.ActionContext;
import docking.action.KeyBindingData;
import ghidra.app.cmd.function.SetVariableCommentCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableCommentFieldLocation;
import ghidra.program.util.VariableLocation;

class VariableCommentDeleteAction
extends ListingContextAction {
    FunctionPlugin funcPlugin;

    VariableCommentDeleteAction(FunctionPlugin plugin) {
        super("Delete Function Variable Comment", plugin.getName(), false);
        this.funcPlugin = plugin;
        this.setKeyBindingData(new KeyBindingData(127, 0));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Function function = this.funcPlugin.getFunction(context);
        if (function == null) {
            return;
        }
        ProgramLocation currentLocation = context.getLocation();
        Variable var = this.getVariable(function, currentLocation);
        if (var == null) {
            return;
        }
        if (var.getComment().equals("")) {
            return;
        }
        if (currentLocation instanceof VariableCommentFieldLocation) {
            this.funcPlugin.execute(context.getProgram(), new SetVariableCommentCmd(var, ""));
        }
    }

    private Variable getVariable(Function function, ProgramLocation currentLocation) {
        if (function == null) {
            return null;
        }
        if (currentLocation instanceof VariableLocation) {
            return ((VariableLocation)currentLocation).getVariable();
        }
        return null;
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        ProgramLocation loc = context.getLocation();
        return loc instanceof VariableCommentFieldLocation;
    }

    public boolean isValidGlobalContext(ActionContext globalContext) {
        return false;
    }
}

