/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.plugin.debug.ShowMemoryDialog;
import ghidra.framework.main.FrontEndOnly;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Support", shortDescription="VM Memory Display", description="Plugin for displaying the VM memory information.")
public class MemoryUsagePlugin
extends Plugin
implements FrontEndOnly {
    private DialogComponentProvider dialog;

    public MemoryUsagePlugin(PluginTool tool) {
        super(tool);
        this.setupActions();
    }

    private void setupActions() {
        DockingAction action = new DockingAction("Show VM memory", this.getName()){

            public void actionPerformed(ActionContext context) {
                MemoryUsagePlugin.this.showMemory();
            }
        };
        action.setEnabled(true);
        action.setHelpLocation(new HelpLocation("FrontEndPlugin", "ShowMemoryUsage"));
        String group = "YYY";
        action.setMenuBarData(new MenuData(new String[]{"Help", "Show VM Memory"}, group));
        this.tool.addAction((DockingActionIf)action);
    }

    void clearDialog() {
        this.dialog = null;
    }

    public void showMemory() {
        if (this.dialog == null) {
            this.dialog = new ShowMemoryDialog(this);
        } else {
            this.dialog.toFront();
        }
    }
}

