/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.AutoAnalysisManagerListener;
import ghidra.app.plugin.exceptionhandlers.gcc.RegionDescriptor;
import ghidra.app.plugin.exceptionhandlers.gcc.sections.DebugFrameSection;
import ghidra.app.plugin.exceptionhandlers.gcc.sections.EhFrameHeaderSection;
import ghidra.app.plugin.exceptionhandlers.gcc.sections.EhFrameSection;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.ExceptionHandlerFrameException;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDAActionRecord;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDAActionTable;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDACallSiteRecord;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDACallSiteTable;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDATypeTable;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class GccExceptionAnalyzer
extends AbstractAnalyzer {
    public static final String NAME = "GCC Exception Handlers";
    public static final String DESCRIPTION = "Locates and annotates exception-handling infrastructure installed by the GCC compiler";
    protected static final String OPTION_NAME_CREATE_TRY_CATCH_COMMENTS = "Create Try Catch Comments";
    private static final String OPTION_DESCRIPTION_CREATE_TRY_CATCH_COMMENTS = "Selecting this check box causes the analyzer to create comments in the disassembly listing for the try and catch code.";
    private static final boolean OPTION_DEFAULT_CREATE_TRY_CATCH_COMMENTS_ENABLED = true;
    private boolean createTryCatchCommentsEnabled = true;
    private Set<Program> visitedPrograms = new HashSet<Program>();
    private AutoAnalysisManagerListener analysisListener = manager -> this.visitedPrograms.remove(manager.getProgram());

    public GccExceptionAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.after().after());
    }

    private MemoryBlock getBlock(Program program, String name) {
        return program.getMemory().getBlock(name);
    }

    private boolean hasBlock(Program program, String name) {
        return this.getBlock(program, name) != null;
    }

    private boolean hasBlockWithPrefix(Program program, String prefix) {
        for (MemoryBlock block : program.getMemory().getBlocks()) {
            if (!block.getName().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean hasARMSection(Program program) {
        return false;
    }

    @Override
    public boolean canAnalyze(Program program) {
        boolean isGcc = program.getCompilerSpec().getCompilerSpecID().getIdAsString().equalsIgnoreCase("gcc");
        boolean isDefault = program.getCompilerSpec().getCompilerSpecID().getIdAsString().equalsIgnoreCase("default");
        if (!isGcc && !isDefault) {
            return false;
        }
        boolean hasEHFrameHeader = this.hasBlock(program, ".eh_frame_hdr");
        boolean hasEHFrame = this.hasBlock(program, ".eh_frame");
        boolean hasDebugFrame = this.hasBlockWithPrefix(program, ".debug_frame");
        return hasEHFrame || hasEHFrameHeader || this.hasARMSection(program) || hasDebugFrame;
    }

    @Override
    public boolean added(Program program, AddressSetView addedLocationAddresses, TaskMonitor monitor, MessageLog log) throws CancelledException {
        if (this.visitedPrograms.contains(program)) {
            return true;
        }
        AutoAnalysisManager analysisManager = AutoAnalysisManager.getAnalysisManager(program);
        analysisManager.addListener(this.analysisListener);
        monitor.setMessage("Analyzing GCC exception-handling artifacts");
        monitor.setIndeterminate(true);
        monitor.setShowProgressValue(false);
        this.handleStandardSections(program, monitor, log);
        this.handleDebugFrameSection(program, monitor, log);
        this.visitedPrograms.add(program);
        return true;
    }

    private void handleStandardSections(Program program, TaskMonitor monitor, MessageLog log) throws CancelledException {
        int fdeTableCount = this.analyzeEhFrameHeaderSection(program, monitor, log);
        monitor.checkCanceled();
        try {
            EhFrameSection ehframeSection = new EhFrameSection(monitor, program);
            List<RegionDescriptor> regions = ehframeSection.analyze(fdeTableCount);
            AddressSet ehProtected = new AddressSet();
            for (RegionDescriptor region : regions) {
                monitor.checkCanceled();
                ehProtected.add(region.getRange());
                LSDACallSiteTable callSiteTable = region.getCallSiteTable();
                if (callSiteTable == null) continue;
                for (LSDACallSiteRecord cs : callSiteTable.getCallSiteRecords()) {
                    monitor.checkCanceled();
                    this.processCallSiteRecord(program, ehProtected, region, cs);
                }
            }
        }
        catch (ExceptionHandlerFrameException | MemoryAccessException e) {
            log.appendMsg("Error analyzing GCC exception tables");
            log.appendException(e);
        }
    }

    private void processCallSiteRecord(Program program, AddressSet ehProtected, RegionDescriptor region, LSDACallSiteRecord cs) {
        AddressRange callSite = cs.getCallSite();
        ehProtected.add(callSite);
        Address csAddr = cs.getCallSite().getMinAddress();
        long lpOffset = cs.getLandingPadOffset();
        if (lpOffset != 0L) {
            Address lpAddr = cs.getLandingPad();
            ehProtected.add(lpAddr);
            List<TypeInfo> typeInfos = this.getTypeInfos(region, cs);
            this.disassembleIfNeeded(program, csAddr);
            if (this.createTryCatchCommentsEnabled) {
                this.markStartOfTry(program, callSite, lpAddr);
                this.markEndOfTry(program, callSite);
            }
            this.disassembleIfNeeded(program, lpAddr);
            if (this.createTryCatchCommentsEnabled) {
                this.markStartOfCatch(program, csAddr, lpAddr, typeInfos);
                this.markEndOfCatch(program, callSite, lpAddr);
            }
        }
    }

    private List<TypeInfo> getTypeInfos(RegionDescriptor region, LSDACallSiteRecord cs) {
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
        LSDAActionTable actionTable = region.getActionTable();
        LSDATypeTable typeTable = region.getTypeTable();
        if (actionTable == null || typeTable == null) {
            return typeInfos;
        }
        int actionOffset = cs.getActionOffset();
        for (LSDAActionRecord action = actionTable.getActionRecordAtOffset(actionOffset); action != null; action = action.getNextAction()) {
            int actionFilter = action.getActionTypeFilter();
            Address typeInfoAddress = typeTable.getTypeInfoAddress(actionFilter);
            TypeInfo typeInfo = new TypeInfo(typeInfoAddress, actionFilter);
            typeInfos.add(typeInfo);
        }
        return typeInfos;
    }

    private boolean shouldDisassemble() {
        return true;
    }

    private boolean disassembleIfNeeded(Program program, Address address) {
        if (!this.shouldDisassemble()) {
            return false;
        }
        Listing listing = program.getListing();
        Instruction inst = listing.getInstructionAt(address);
        AutoAnalysisManager.getAnalysisManager(program).setProtectedLocation(address);
        if (inst == null) {
            DisassembleCommand cmd = new DisassembleCommand(address, null, true);
            if (!cmd.applyTo((DomainObject)program) || cmd.getDisassembledAddressSet().isEmpty()) {
                String message = "Failed to disassemble at " + address;
                Msg.error((Object)this, (Object)message);
                return false;
            }
            return true;
        }
        return false;
    }

    private void markStartOfTry(Program program, AddressRange callSite, Address lpAddr) {
        Address csMinAddr = callSite.getMinAddress();
        Address csMaxAddr = callSite.getMaxAddress();
        String startTryComment = "try { // try from " + csMinAddr + " to " + csMaxAddr + " has its CatchHandler @ " + lpAddr;
        String existingComment = program.getListing().getComment(1, csMinAddr);
        if (existingComment == null || !existingComment.contains(startTryComment)) {
            String mergedComment = StringUtilities.mergeStrings((String)existingComment, (String)startTryComment);
            SetCommentCmd setCommentCmd = new SetCommentCmd(csMinAddr, 1, mergedComment);
            setCommentCmd.applyTo((DomainObject)program);
        }
    }

    private void markEndOfTry(Program program, AddressRange callSite) {
        Address csMinAddr = callSite.getMinAddress();
        Address csMaxAddr = callSite.getMaxAddress();
        CodeUnit csMaxCodeUnit = program.getListing().getCodeUnitContaining(csMaxAddr);
        if (csMaxCodeUnit != null) {
            Address commentAddr = csMaxCodeUnit.getMinAddress();
            String endTryComment = "} // end try from " + csMinAddr + " to " + csMaxAddr;
            String existingComment = program.getListing().getComment(2, commentAddr);
            if (existingComment == null || !existingComment.contains(endTryComment)) {
                String mergedComment = StringUtilities.mergeStrings((String)existingComment, (String)endTryComment);
                SetCommentCmd setCommentCmd = new SetCommentCmd(commentAddr, 2, mergedComment);
                setCommentCmd.applyTo((DomainObject)program);
            }
        }
    }

    private void markStartOfCatch(Program program, Address csAddr, Address lpAddr, List<TypeInfo> typeInfos) {
        String typeString = typeInfos.stream().map(a -> this.getCatchParamInfo((TypeInfo)a)).collect(Collectors.joining(", "));
        String startCatchComment = "catch(" + typeString + ") { ... } // from try @ " + csAddr + " with catch @ " + lpAddr;
        String existingComment = program.getListing().getComment(1, lpAddr);
        if (existingComment == null || !existingComment.contains(startCatchComment)) {
            String mergedComment = StringUtilities.mergeStrings((String)existingComment, (String)startCatchComment);
            SetCommentCmd setCommentCmd = new SetCommentCmd(lpAddr, 1, mergedComment);
            setCommentCmd.applyTo((DomainObject)program);
        }
    }

    private String getCatchParamInfo(TypeInfo a) {
        int actionFilter = a.getActionFilter();
        Address typeInfoAddress = a.getTypeInfoAddress();
        if (actionFilter == 0 || typeInfoAddress == Address.NO_ADDRESS) {
            return "";
        }
        return "type#" + actionFilter + " @ " + typeInfoAddress;
    }

    private void markEndOfCatch(Program program, AddressRange callSite, Address lpAddr) {
    }

    private int analyzeEhFrameHeaderSection(Program program, TaskMonitor monitor, MessageLog log) {
        try {
            EhFrameHeaderSection ehframehdrSection = new EhFrameHeaderSection(program);
            return ehframehdrSection.analyze(monitor);
        }
        catch (ExceptionHandlerFrameException | AddressOutOfBoundsException | MemoryAccessException e) {
            log.appendMsg("Error analyzing GCC EH Frame Header exception table");
            log.appendException(e);
            return 0;
        }
    }

    private void handleDebugFrameSection(Program program, TaskMonitor monitor, MessageLog log) throws CancelledException {
        try {
            DebugFrameSection debugFrameSection = new DebugFrameSection(monitor, program);
            debugFrameSection.analyze();
        }
        catch (ExceptionHandlerFrameException | MemoryAccessException e) {
            log.appendMsg("Error analyzing GCC DebugFrame exception tables");
            log.appendException(e);
        }
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_CREATE_TRY_CATCH_COMMENTS, (Object)this.createTryCatchCommentsEnabled, null, OPTION_DESCRIPTION_CREATE_TRY_CATCH_COMMENTS);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.createTryCatchCommentsEnabled = options.getBoolean(OPTION_NAME_CREATE_TRY_CATCH_COMMENTS, this.createTryCatchCommentsEnabled);
    }

    private class TypeInfo {
        private Address typeInfoAddress;
        private int actionFilter;

        public TypeInfo(Address typeInfoAddress, int actionFilter) {
            this.typeInfoAddress = typeInfoAddress;
            this.actionFilter = actionFilter;
        }

        public Address getTypeInfoAddress() {
            return this.typeInfoAddress;
        }

        public int getActionFilter() {
            return this.actionFilter;
        }
    }
}

