/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.plugin.exceptionhandlers.gcc.RegionDescriptor;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDAActionTable;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDACallSiteRecord;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDACallSiteTable;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDAHeader;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDATypeTable;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.task.TaskMonitor;

public class LSDATable {
    private TaskMonitor monitor;
    private Program program;
    private LSDAHeader header;
    private LSDACallSiteTable callSiteTable;
    private LSDAActionTable actionTable;
    private LSDATypeTable typeTable;

    public LSDATable(TaskMonitor monitor, Program program) {
        this.monitor = monitor;
        this.program = program;
    }

    public void create(Address tableAddr, RegionDescriptor region) throws MemoryAccessException {
        Address tTypeBaseAddress;
        region.setLSDATable(this);
        Address baseAdress = tableAddr;
        this.header = new LSDAHeader(this.monitor, this.program, region);
        this.header.create(tableAddr);
        tableAddr = this.header.getNextAddress();
        this.callSiteTable = new LSDACallSiteTable(this.monitor, this.program, region);
        this.callSiteTable.create(tableAddr);
        tableAddr = this.callSiteTable.getNextAddress();
        int maxActionOffset = 0;
        boolean generateActionTable = false;
        for (LSDACallSiteRecord cs : this.callSiteTable.getCallSiteRecords()) {
            maxActionOffset = Math.max(maxActionOffset, cs.getActionOffset());
            if ((long)cs.getActionOffset() == 0L) continue;
            generateActionTable = true;
        }
        if (generateActionTable) {
            Address maxTableAddr = tableAddr.add((long)maxActionOffset);
            this.actionTable = new LSDAActionTable(this.monitor, this.program, region);
            this.actionTable.create(tableAddr, maxTableAddr);
            tableAddr = this.actionTable.getNextAddress();
        }
        if (this.header.getTTypeEncoding() != 255 && (tTypeBaseAddress = this.header.getTTypeBaseAddress()) != Address.NO_ADDRESS) {
            this.typeTable = new LSDATypeTable(this.monitor, this.program, region);
            this.typeTable.create(tTypeBaseAddress, tableAddr);
        }
        SetCommentCmd commentCmd = new SetCommentCmd(baseAdress, 3, "Language-Specific Data Area");
        commentCmd.applyTo((DomainObject)this.program);
    }

    LSDAHeader getHeader() {
        return this.header;
    }

    public LSDACallSiteTable getCallSiteTable() {
        return this.callSiteTable;
    }

    public LSDAActionTable getActionTable() {
        return this.actionTable;
    }

    public LSDATypeTable getTypeTable() {
        return this.typeTable;
    }
}

