/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.headless;

import ghidra.util.Issue;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.IssueListener;
import ghidra.util.task.TaskMonitor;
import java.util.Timer;
import java.util.TimerTask;

public class HeadlessTimedTaskMonitor
implements TaskMonitor {
    private Timer timer = new Timer();
    private volatile boolean isCancelled = false;

    HeadlessTimedTaskMonitor(int timeoutSecs) {
        this.timer.schedule((TimerTask)new TimeOutTask(), timeoutSecs * 1000);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setShowProgressValue(boolean showProgressValue) {
    }

    public void setMessage(String message) {
    }

    public void setProgress(long value) {
    }

    public void initialize(long max) {
    }

    public void setMaximum(long max) {
    }

    public long getMaximum() {
        return 0L;
    }

    public void setIndeterminate(boolean indeterminate) {
    }

    public void checkCanceled() throws CancelledException {
        if (this.isCancelled()) {
            throw new CancelledException();
        }
    }

    public void incrementProgress(long incrementAmount) {
    }

    public long getProgress() {
        return 0L;
    }

    public void reportIssue(Issue issue) {
    }

    public void cancel() {
        this.timer.cancel();
        this.isCancelled = true;
    }

    public void addCancelledListener(CancelledListener listener) {
    }

    public void removeCancelledListener(CancelledListener listener) {
    }

    public void addIssueListener(IssueListener listener) {
    }

    public void removeIssueListener(IssueListener listener) {
    }

    public void setCancelEnabled(boolean enable) {
    }

    public boolean isCancelEnabled() {
        return true;
    }

    public void clearCanceled() {
        this.isCancelled = false;
    }

    private class TimeOutTask
    extends TimerTask {
        private TimeOutTask() {
        }

        @Override
        public void run() {
            HeadlessTimedTaskMonitor.this.cancel();
        }
    }
}

