/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.RowLayout;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.format.ErrorListingField;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import java.util.ArrayList;
import java.util.List;

class Row {
    List<FieldFactory> fields = new ArrayList<FieldFactory>();
    int width = 0;

    Row() {
    }

    public void insertField(FieldFactory ff, int colIndex) {
        this.fields.add(colIndex, ff);
        this.layoutFields();
    }

    public void optionsChanged(Options options, String name, Object oldValue, Object newValue) {
        for (FieldFactory factory : this.fields) {
            factory.optionsChanged(options, name, oldValue, newValue);
        }
    }

    public void servicesChanged() {
        for (int i = 0; i < this.fields.size(); ++i) {
            FieldFactory factory = this.fields.get(i);
            factory.servicesChanged();
        }
    }

    public void addField(FieldFactory ff) {
        this.fields.add(ff);
        this.layoutFields();
    }

    public void layoutFields() {
        this.width = 0;
        for (int i = 0; i < this.fields.size(); ++i) {
            FieldFactory factory = this.fields.get(i);
            factory.setStartX(this.width);
            this.width += factory.getWidth();
        }
    }

    public RowLayout getLayout(int index, ProxyObj<?> proxy, int id) {
        ArrayList<ListingField> temp = new ArrayList<ListingField>(20);
        int varWidth = 0;
        for (int i = 0; i < this.fields.size(); ++i) {
            FieldFactory ff = this.fields.get(i);
            ListingField f = null;
            try {
                f = ff.getField(proxy, varWidth);
            }
            catch (Throwable t) {
                f = new ErrorListingField(ff, proxy, varWidth, t);
            }
            if (f == null) continue;
            if (f.getWidth() != ff.getWidth()) {
                varWidth += f.getWidth() - ff.getWidth();
            }
            temp.add(f);
        }
        if (temp.size() > 0) {
            Field[] rowFields = new Field[temp.size()];
            rowFields = temp.toArray(rowFields);
            temp.clear();
            return new RowLayout(rowFields, id);
        }
        return null;
    }

    public FieldFactory[] getFactorys() {
        FieldFactory[] ffs = new FieldFactory[this.fields.size()];
        return this.fields.toArray(ffs);
    }

    public int size() {
        return this.fields.size();
    }

    public FieldFactory removeField(int colIndex) {
        FieldFactory ff = this.fields.remove(colIndex);
        this.layoutFields();
        return ff;
    }

    public String toString() {
        return this.fields.toString();
    }
}

