/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.DefaultAddressFactory;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.DuplicateNameException;

public class ProgramAddressFactory
extends DefaultAddressFactory {
    private AddressFactory originalFactory;
    private AddressSpace stackSpace;

    public ProgramAddressFactory(Language language, CompilerSpec compilerSpec) {
        super(language.getAddressFactory().getAllAddressSpaces(), language.getAddressFactory().getDefaultAddressSpace());
        this.originalFactory = language.getAddressFactory();
        this.initOtherSpace(language);
        this.initExternalSpace(language);
        this.initStackSpace(language, compilerSpec);
        this.initHashSpace(language);
        this.initJoinSpace(language);
    }

    private void initOtherSpace(Language language) {
        try {
            this.addAddressSpace(AddressSpace.OTHER_SPACE);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'OTHER' space: " + language.getLanguageID().getIdAsString());
        }
    }

    private void initExternalSpace(Language language) {
        try {
            this.addAddressSpace(AddressSpace.EXTERNAL_SPACE);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'EXTERNAL' space: " + language.getLanguageID().getIdAsString());
        }
    }

    private void initStackSpace(Language language, CompilerSpec compilerSpec) {
        this.stackSpace = compilerSpec.getStackSpace();
        try {
            this.addAddressSpace(this.stackSpace);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'STACK' space: " + language.getLanguageID().getIdAsString());
        }
    }

    private void initHashSpace(Language language) {
        try {
            this.addAddressSpace(AddressSpace.HASH_SPACE);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'HASH' space: " + language.getLanguageID().getIdAsString());
        }
    }

    private void initJoinSpace(Language language) {
        try {
            this.addAddressSpace(AddressSpace.VARIABLE_SPACE);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'JOIN' space: " + language.getLanguageID().getIdAsString());
        }
    }

    @Override
    public AddressSpace getStackSpace() {
        return this.stackSpace;
    }

    AddressFactory getOriginalAddressFactory() {
        return this.originalFactory;
    }

    public void addOverlayAddressSpace(OverlayAddressSpace ovSpace) throws DuplicateNameException {
        this.addAddressSpace(ovSpace);
    }

    public OverlayAddressSpace addOverlayAddressSpace(String name, AddressSpace originalSpace, long minOffset, long maxOffset) throws DuplicateNameException {
        int unique = 0;
        if (originalSpace.getType() == 1) {
            unique = this.getNextUniqueID();
        }
        OverlayAddressSpace ovSpace = new OverlayAddressSpace(name, originalSpace, unique, minOffset, maxOffset);
        this.addAddressSpace(ovSpace);
        return ovSpace;
    }

    @Override
    public Address getAddress(int spaceID, long offset) {
        Address addr = super.getAddress(spaceID, offset);
        if (addr == null && spaceID == this.stackSpace.getUniqueSpaceID()) {
            return this.stackSpace.getAddress(offset);
        }
        return addr;
    }

    @Override
    public Address getAddress(String addrString) {
        Address addr = null;
        if (addrString.startsWith("Stack[") && addrString.endsWith("]")) {
            try {
                long stackOffset = NumericUtilities.parseHexLong((String)addrString.substring(6, addrString.length() - 1));
                addr = this.stackSpace.getAddress(stackOffset);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            addr = super.getAddress(addrString);
        }
        return addr;
    }

    void removeOverlaySpace(String name) {
        this.removeAddressSpace(name);
    }

    @Override
    protected void renameOverlaySpace(String oldName, String newName) throws DuplicateNameException {
        super.renameOverlaySpace(oldName, newName);
    }

    private int getNextUniqueID() {
        int maxID = 0;
        AddressSpace[] spaces = this.getAllAddressSpaces();
        for (int i = 0; i < spaces.length; ++i) {
            maxID = Math.max(maxID, spaces[i].getUnique());
        }
        return maxID + 1;
    }
}

