/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.Field;
import db.IntField;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.Table;
import ghidra.program.database.data.ArrayDBAdapter;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class ArrayDBAdapterV1
extends ArrayDBAdapter {
    static final int VERSION = 1;
    static final String ARRAY_TABLE_NAME = "Arrays";
    static final int V1_ARRAY_DT_ID_COL = 0;
    static final int V1_ARRAY_DIM_COL = 1;
    static final int V1_ARRAY_LENGTH_COL = 2;
    static final int V1_ARRAY_CAT_COL = 3;
    private Table table;
    public static final Schema V1_SCHEMA = new Schema(1, "Array ID", new Class[]{LongField.class, IntField.class, IntField.class, LongField.class}, new String[]{"Data Type ID", "Dimension", "Length", "Cat ID"});

    public ArrayDBAdapterV1(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.table = handle.createTable(ARRAY_TABLE_NAME, V1_SCHEMA, new int[]{3});
        } else {
            this.table = handle.getTable(ARRAY_TABLE_NAME);
            if (this.table == null) {
                throw new VersionException("Missing Table: Arrays");
            }
            if (this.table.getSchema().getVersion() != 1) {
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    public Record createRecord(long dataTypeID, int numberOfElements, int length, long catID) throws IOException {
        long tableKey = this.table.getKey();
        long key = DataTypeManagerDB.createKey(3, tableKey);
        Record record = V1_SCHEMA.createRecord(key);
        record.setLongValue(0, dataTypeID);
        record.setIntValue(1, numberOfElements);
        record.setIntValue(2, length);
        record.setLongValue(3, catID);
        this.table.putRecord(record);
        return record;
    }

    @Override
    public Record getRecord(long arrayID) throws IOException {
        return this.table.getRecord(arrayID);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    public boolean removeRecord(long dataID) throws IOException {
        return this.table.deleteRecord(dataID);
    }

    @Override
    public void updateRecord(Record record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(ARRAY_TABLE_NAME);
    }

    @Override
    long[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 3);
    }
}

