/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.OverlapCodeSubModel;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.LinkedList;

public class IsolatedEntrySubModel
extends OverlapCodeSubModel {
    public static final String ISOLATED_MODEL_NAME = "Isolated Entry";

    public IsolatedEntrySubModel(Program program) {
        super(program);
    }

    public IsolatedEntrySubModel(Program program, boolean includeExternals) {
        super(program, includeExternals);
    }

    @Override
    protected CodeBlock getSubroutine(Address mStartAddr, TaskMonitor monitor) throws CancelledException {
        CodeBlock mSub = this.modelM.getCodeBlockAt(mStartAddr, monitor);
        if (mSub == null) {
            return null;
        }
        Address[] mEntryPts = mSub.getStartAddresses();
        ArrayList<Address> startSet = new ArrayList<Address>();
        for (int i = 0; i < mEntryPts.length; ++i) {
            if (mStartAddr.equals(mEntryPts[i])) continue;
            startSet.add(mEntryPts[i]);
        }
        AddressSet addrSet = new AddressSet();
        LinkedList<Address> todoList = new LinkedList<Address>();
        todoList.addFirst(mStartAddr);
        CodeBlockModel bbModel = this.modelM.getBasicBlockModel();
        while (!todoList.isEmpty()) {
            CodeBlock bblock;
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Address a = (Address)todoList.removeLast();
            if (addrSet.contains(a) || startSet.contains(a) || (bblock = bbModel.getFirstCodeBlockContaining(a, monitor)) == null || this.listing.getInstructionAt(a) == null) continue;
            addrSet.add(bblock);
            CodeBlockReferenceIterator destIter = bblock.getDestinations(monitor);
            while (destIter.hasNext()) {
                CodeBlockReference destRef = destIter.next();
                FlowType refFlowType = destRef.getFlowType();
                if (!refFlowType.isJump() && !refFlowType.isFallthrough()) continue;
                todoList.add(destRef.getDestinationAddress());
            }
        }
        return this.createSub(addrSet, mStartAddr);
    }

    @Override
    public String getName() {
        return ISOLATED_MODEL_NAME;
    }
}

