/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;

public class AlignmentDataType
extends BuiltIn
implements Dynamic {
    private static final long serialVersionUID = 1L;
    private static final int MAX_LENGTH = 1024;

    public AlignmentDataType() {
        this(null);
    }

    public AlignmentDataType(DataTypeManager dtm) {
        super(null, "Alignment", dtm);
    }

    private int computeLength(MemBuffer buf) {
        int length = 0;
        try {
            byte startByte = buf.getByte(0);
            Listing listing = null;
            try {
                if (buf.getMemory() != null && buf.getMemory().getProgram() != null) {
                    listing = buf.getMemory().getProgram().getListing();
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            while (length < 1024) {
                byte b = buf.getByte(length);
                Address addr = buf.getAddress().add(length);
                if ((listing == null || listing.getDefinedDataAt(addr) == null && listing.getInstructionAt(addr) == null) && b == startByte) {
                    ++length;
                    continue;
                }
                break;
            }
        }
        catch (MemoryAccessException memoryAccessException) {
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            // empty catch block
        }
        return length > 0 ? length : -1;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new AlignmentDataType(dtm);
    }

    @Override
    public boolean isDynamicallySized() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Consumes alignment/repeating bytes.";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "align";
    }

    @Override
    public boolean canSpecifyLength() {
        return true;
    }

    @Override
    public int getLength(MemBuffer buf, int length) {
        if (length < 0) {
            length = this.computeLength(buf);
        }
        return length;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "align(" + length + ")";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.getRepresentation(buf, settings, length);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return String.class;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public DataType getReplacementBaseType() {
        return ByteDataType.dataType;
    }
}

