/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.JavaEnumSettingsDefinition;
import ghidra.docking.settings.Settings;

public class TranslationSettingsDefinition
extends JavaEnumSettingsDefinition<TRANSLATION_ENUM> {
    public static final TranslationSettingsDefinition TRANSLATION = new TranslationSettingsDefinition();
    private static final String TRANSLATED_VALUE_SETTING_NAME = "translation";
    private static final String SHOW_TRANSLATED_TOGGLE_SETTING_NAME = "translated";

    private TranslationSettingsDefinition() {
        super(SHOW_TRANSLATED_TOGGLE_SETTING_NAME, "Translation", "Selects the display of translated strings", (Enum)TRANSLATION_ENUM.SHOW_ORIGINAL);
    }

    public boolean isShowTranslated(Settings settings) {
        return this.getEnumValue(settings) == TRANSLATION_ENUM.SHOW_TRANSLATED;
    }

    public void setShowTranslated(Settings settings, boolean shouldShowTranslatedValue) {
        this.setEnumValue(settings, shouldShowTranslatedValue ? TRANSLATION_ENUM.SHOW_TRANSLATED : TRANSLATION_ENUM.SHOW_ORIGINAL);
    }

    public boolean hasTranslatedValue(Settings settings) {
        return settings.getString(TRANSLATED_VALUE_SETTING_NAME) != null;
    }

    public String getTranslatedValue(Settings settings) {
        return settings.getString(TRANSLATED_VALUE_SETTING_NAME);
    }

    public void setTranslatedValue(Settings settings, String translatedValue) {
        settings.setString(TRANSLATED_VALUE_SETTING_NAME, translatedValue);
    }

    public void clear(Settings settings) {
        super.clear(settings);
        settings.clearSetting(TRANSLATED_VALUE_SETTING_NAME);
    }

    public void copySetting(Settings srcSettings, Settings destSettings) {
        super.copySetting(srcSettings, destSettings);
        String translated = srcSettings.getString(TRANSLATED_VALUE_SETTING_NAME);
        if (translated == null) {
            destSettings.clearSetting(TRANSLATED_VALUE_SETTING_NAME);
        } else {
            destSettings.setString(TRANSLATED_VALUE_SETTING_NAME, translated);
        }
    }

    public static enum TRANSLATION_ENUM {
        SHOW_ORIGINAL("show original"),
        SHOW_TRANSLATED("show translated");

        private final String s;

        private TRANSLATION_ENUM(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }

        public TRANSLATION_ENUM invert() {
            return this == SHOW_ORIGINAL ? SHOW_TRANSLATED : SHOW_ORIGINAL;
        }
    }
}

