/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.remote;

import ch.ethz.ssh2.signature.DSAPrivateKey;
import ch.ethz.ssh2.signature.DSASHA1Verify;
import ch.ethz.ssh2.signature.DSASignature;
import ch.ethz.ssh2.signature.RSAPrivateKey;
import ch.ethz.ssh2.signature.RSASHA1Verify;
import ch.ethz.ssh2.signature.RSASignature;
import generic.random.SecureRandomFactory;
import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import javax.security.auth.callback.Callback;

public class SSHSignatureCallback
implements Callback,
Serializable {
    public static final long serialVersionUID = 1L;
    private final byte[] token;
    private final byte[] serverSignature;
    private byte[] signature;

    public SSHSignatureCallback(byte[] token, byte[] serverSignature) {
        this.token = token;
        this.serverSignature = serverSignature;
    }

    public byte[] getToken() {
        return this.token == null ? null : (byte[])this.token.clone();
    }

    public byte[] getSignature() {
        return this.signature == null ? null : (byte[])this.signature.clone();
    }

    public byte[] getServerSignature() {
        return this.serverSignature;
    }

    public boolean isSigned() {
        return this.signature != null;
    }

    public void sign(Object sshPrivateKey) throws IOException {
        if (sshPrivateKey instanceof RSAPrivateKey) {
            RSAPrivateKey key = (RSAPrivateKey)sshPrivateKey;
            RSASignature rsaSignature = RSASHA1Verify.generateSignature((byte[])this.token, (RSAPrivateKey)key);
            this.signature = RSASHA1Verify.encodeSSHRSASignature((RSASignature)rsaSignature);
        } else if (sshPrivateKey instanceof DSAPrivateKey) {
            DSAPrivateKey key = (DSAPrivateKey)sshPrivateKey;
            SecureRandom random = SecureRandomFactory.getSecureRandom();
            DSASignature dsaSignature = DSASHA1Verify.generateSignature((byte[])this.token, (DSAPrivateKey)key, (SecureRandom)random);
            this.signature = DSASHA1Verify.encodeSSHDSASignature((DSASignature)dsaSignature);
        } else {
            throw new IllegalArgumentException("Unsupported SSH private key");
        }
    }
}

