/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.jackrabbit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.api.JackrabbitNodeTypeManager;
import org.apache.jackrabbit.rmi.jackrabbit.RemoteJackrabbitNodeTypeManager;
import org.apache.jackrabbit.rmi.remote.RemoteNodeType;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerNodeTypeManager;

public class ServerJackrabbitNodeTypeManager
extends ServerNodeTypeManager
implements RemoteJackrabbitNodeTypeManager {
    private final JackrabbitNodeTypeManager manager;

    public ServerJackrabbitNodeTypeManager(JackrabbitNodeTypeManager manager, RemoteAdapterFactory factory) throws RemoteException {
        super(manager, factory);
        this.manager = manager;
    }

    public boolean hasNodeType(String name) throws RepositoryException {
        return this.manager.hasNodeType(name);
    }

    public RemoteNodeType[] registerNodeTypes(byte[] content, String type) throws RepositoryException {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(content);
            NodeType[] types = this.manager.registerNodeTypes(stream, type);
            RemoteNodeType[] remotes = new RemoteNodeType[types.length];
            for (int i = 0; i < types.length; ++i) {
                remotes[i] = this.getFactory().getRemoteNodeType(types[i]);
            }
            return remotes;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

