/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.simple;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.webdav.simple.ItemFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultItemFilter
implements ItemFilter {
    private static Logger log = LoggerFactory.getLogger((Class)DefaultItemFilter.class);
    private List prefixFilter = new ArrayList();
    private List uriFilter = new ArrayList();
    private List nodetypeFilter = new ArrayList();

    public void setFilteredURIs(String[] uris) {
        if (uris != null) {
            for (int i = 0; i < uris.length; ++i) {
                this.uriFilter.add(uris[i]);
            }
        }
    }

    public void setFilteredPrefixes(String[] prefixes) {
        if (prefixes != null) {
            for (int i = 0; i < prefixes.length; ++i) {
                this.prefixFilter.add(prefixes[i]);
            }
        }
    }

    public void setFilteredNodetypes(String[] nodetypeNames) {
        if (nodetypeNames != null) {
            for (int i = 0; i < nodetypeNames.length; ++i) {
                this.nodetypeFilter.add(nodetypeNames[i]);
            }
        }
    }

    public boolean isFilteredItem(Item item) {
        return this.isFilteredNamespace(item) || this.isFilteredNodeType(item);
    }

    public boolean isFilteredItem(String displayName, Session session) {
        return this.isFilteredNamespace(displayName, session);
    }

    private boolean isFilteredNamespace(String name, Session session) {
        if (this.prefixFilter.isEmpty() && this.uriFilter.isEmpty()) {
            return false;
        }
        int pos = name.indexOf(":");
        if (pos < 0) {
            return false;
        }
        try {
            String prefix = name.substring(0, pos);
            String uri = session.getNamespaceURI(prefix);
            return this.prefixFilter.contains(prefix) || this.uriFilter.contains(uri);
        }
        catch (RepositoryException e) {
            log.warn(e.getMessage());
            return false;
        }
    }

    private boolean isFilteredNamespace(Item item) {
        try {
            return this.isFilteredNamespace(item.getName(), item.getSession());
        }
        catch (RepositoryException e) {
            log.warn(e.getMessage());
            return false;
        }
    }

    private boolean isFilteredNodeType(Item item) {
        if (this.nodetypeFilter.isEmpty()) {
            return false;
        }
        try {
            String ntName = item.isNode() ? ((Node)item).getDefinition().getDeclaringNodeType().getName() : ((Property)item).getDefinition().getDeclaringNodeType().getName();
            return this.nodetypeFilter.contains(ntName);
        }
        catch (RepositoryException e) {
            log.warn(e.getMessage());
            return false;
        }
    }
}

