/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.diff;

import ghidra.app.nav.LocationMemento;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.plugin.core.codebrowser.CodeViewerLocationMemento;
import ghidra.app.plugin.core.diff.ProgramDiffPlugin;
import ghidra.app.util.HighlightProvider;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import javax.swing.Icon;

class DiffNavigatable
implements Navigatable {
    private ProgramDiffPlugin diffPlugin;
    private Navigatable navigatable;
    private boolean disposed = false;
    private WeakSet<NavigatableRemovalListener> navigationListeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();

    DiffNavigatable(ProgramDiffPlugin diffPlugin, Navigatable navigatable) {
        this.diffPlugin = diffPlugin;
        this.navigatable = navigatable;
    }

    public boolean goTo(Program program, ProgramLocation location) {
        return this.navigatable.goTo(program, location);
    }

    public ProgramLocation getLocation() {
        return this.navigatable.getLocation();
    }

    public Program getProgram() {
        return this.diffPlugin.getSecondProgram();
    }

    public LocationMemento getMemento() {
        int cursorOffset = this.diffPlugin.getListingPanel().getFieldPanel().getCursorOffset();
        return new CodeViewerLocationMemento(this.diffPlugin.getSecondProgram(), this.diffPlugin.getCurrentLocation(), cursorOffset);
    }

    public void setMemento(LocationMemento memento) {
        CodeViewerLocationMemento cvMemento = (CodeViewerLocationMemento)memento;
        int cursorOffset = cvMemento.getCursorOffset();
        this.diffPlugin.getListingPanel().getFieldPanel().positionCursor(cursorOffset);
    }

    public Icon getNavigatableIcon() {
        return this.navigatable.getNavigatableIcon();
    }

    public boolean isConnected() {
        return true;
    }

    public boolean supportsMarkers() {
        return this.isConnected();
    }

    public void requestFocus() {
        this.diffPlugin.getListingPanel().getFieldPanel().requestFocus();
    }

    public boolean isVisible() {
        return this.navigatable.isVisible() && this.diffPlugin.isShowingDiff();
    }

    public long getInstanceID() {
        return this.navigatable.getInstanceID();
    }

    public void setSelection(ProgramSelection selection) {
        if (selection == null) {
            selection = new ProgramSelection();
        }
        this.diffPlugin.setProgram2Selection(selection);
    }

    public void setHighlight(ProgramSelection highlight) {
    }

    public ProgramSelection getSelection() {
        return this.navigatable.getSelection();
    }

    public ProgramSelection getHighlight() {
        return this.navigatable.getHighlight();
    }

    public void addNavigatableListener(NavigatableRemovalListener listener) {
        this.navigationListeners.add((Object)listener);
    }

    public void removeNavigatableListener(NavigatableRemovalListener listener) {
        this.navigationListeners.remove((Object)listener);
    }

    public void dispose() {
        this.disposed = true;
        for (NavigatableRemovalListener listener : this.navigationListeners) {
            listener.navigatableRemoved((Navigatable)this);
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean supportsHighlight() {
        return true;
    }

    public void setHighlightProvider(HighlightProvider highlightProvider, Program program) {
        this.navigatable.setHighlightProvider(highlightProvider, program);
    }

    public void removeHighlightProvider(HighlightProvider highlightProvider, Program program) {
        this.navigatable.removeHighlightProvider(highlightProvider, program);
    }
}

