/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class StringField
extends Field {
    private static String ENCODING = "UTF-8";
    private String str;
    private byte[] bytes;

    public StringField() {
    }

    public StringField(String s) {
        this.setString(s);
    }

    @Override
    public String getString() {
        return this.str;
    }

    @Override
    public void setString(String str) {
        this.str = str;
        try {
            this.bytes = str != null ? str.getBytes(ENCODING) : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertException();
        }
    }

    @Override
    int length() {
        return this.bytes == null ? 4 : this.bytes.length + 4;
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        if (this.bytes == null) {
            return buf.putInt(offset, -1);
        }
        offset = buf.putInt(offset, this.bytes.length);
        return buf.put(offset, this.bytes);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        int len = buf.getInt(offset);
        offset += 4;
        if (len < 0) {
            this.str = null;
            this.bytes = null;
        } else {
            this.bytes = buf.get(offset, len);
            this.str = new String(this.bytes, ENCODING);
            offset += len;
        }
        return offset;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        int len = buf.getInt(offset);
        return (len < 0 ? 0 : len) + 4;
    }

    @Override
    public boolean isVariableLength() {
        return true;
    }

    @Override
    protected byte getFieldType() {
        return 4;
    }

    public String toString() {
        return "StringField: " + this.str;
    }

    @Override
    public String getValueAsString() {
        return "\"" + this.str + "\"";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StringField)) {
            return false;
        }
        StringField f = (StringField)obj;
        if (this.str == null) {
            return f.str == null;
        }
        return this.str.equals(f.str);
    }

    @Override
    public byte[] getBinaryData() {
        return this.bytes;
    }

    @Override
    public void setBinaryData(byte[] bytes) {
        if (bytes == null) {
            this.str = null;
        } else {
            this.bytes = bytes;
            try {
                this.str = new String(bytes, ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertException();
            }
        }
    }

    @Override
    void truncate(int length) {
        int maxLen = length - 4;
        if (this.str != null && this.str.length() > maxLen) {
            this.setString(this.str.substring(0, maxLen));
        }
    }

    @Override
    public int compareTo(Field o) {
        StringField f = (StringField)o;
        if (this.str == null) {
            if (f.str == null) {
                return 0;
            }
            return -1;
        }
        if (f.str == null) {
            return 1;
        }
        return this.str.compareTo(f.str);
    }

    @Override
    public Field newField(Field fieldValue) {
        if (fieldValue instanceof StringField) {
            return new StringField(fieldValue.getString());
        }
        try {
            return new StringField(new String(fieldValue.getBinaryData(), ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertException();
        }
    }

    @Override
    public Field newField() {
        return new StringField();
    }

    @Override
    public int hashCode() {
        return this.str.hashCode();
    }
}

