/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.hash.FidHashQuad;
import ghidra.feature.fid.service.FidMatch;
import ghidra.program.model.listing.Function;
import java.util.ArrayList;
import java.util.List;

public class FidSearchResult {
    public Function function;
    public FidHashQuad hashQuad;
    public List<FidMatch> matches;

    public FidSearchResult(Function func, FidHashQuad hashQuad, List<FidMatch> matches) {
        this.function = func;
        this.hashQuad = hashQuad;
        this.matches = matches;
    }

    public void filterBySymbolPrefix(String prefix) {
        ArrayList<FidMatch> result = new ArrayList<FidMatch>();
        for (FidMatch match : this.matches) {
            FunctionRecord function = match.getFunctionRecord();
            if (function.getName().startsWith(prefix)) continue;
            result.add(match);
        }
        this.matches = result;
    }
}

