/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.odex;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.odex.OdexConstants;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class OdexHeader
implements StructConverter {
    private byte[] magic;
    private int dexOffset;
    private int dexLength;
    private int depsOffset;
    private int depsLength;
    private int auxOffset;
    private int auxLength;
    private int flags;
    private int padding;

    public OdexHeader(BinaryReader reader) throws IOException {
        this.magic = reader.readNextByteArray(OdexConstants.ODEX_MAGIC_LENGTH);
        this.dexOffset = reader.readNextInt();
        this.dexLength = reader.readNextInt();
        this.depsOffset = reader.readNextInt();
        this.depsLength = reader.readNextInt();
        this.auxOffset = reader.readNextInt();
        this.auxLength = reader.readNextInt();
        this.flags = reader.readNextInt();
        this.padding = reader.readNextInt();
    }

    public String getMagic() {
        return new String(this.magic);
    }

    public int getDexOffset() {
        return this.dexOffset;
    }

    public int getDexLength() {
        return this.dexLength;
    }

    public int getDepsOffset() {
        return this.depsOffset;
    }

    public int getDepsLength() {
        return this.depsLength;
    }

    public int getAuxOffset() {
        return this.auxOffset;
    }

    public int getAuxLength() {
        return this.auxLength;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getPadding() {
        return this.padding;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("odex_header_item", 0);
        structure.add(UTF8, OdexConstants.ODEX_MAGIC_LENGTH, "magic", null);
        structure.add(DWORD, "dex_offset", null);
        structure.add(DWORD, "dex_length", null);
        structure.add(DWORD, "deps_offset", null);
        structure.add(DWORD, "deps_length", null);
        structure.add(DWORD, "aux_offset", null);
        structure.add(DWORD, "aux_length", null);
        structure.add(DWORD, "flags", null);
        structure.add(DWORD, "padding", null);
        return structure;
    }
}

