/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.program;

import ghidra.app.plugin.prototype.match.ExactBytesFunctionHasher;
import ghidra.app.plugin.prototype.match.FunctionHasher;
import ghidra.feature.vt.api.correlator.program.FunctionMatchProgramCorrelator;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelatorFactory;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;

public class ExactMatchBytesProgramCorrelatorFactory
extends VTAbstractProgramCorrelatorFactory {
    static final String DESC = "Compares code by hashing bytes, looking for identical functions. It reports back any that have ONLY ONE identical match.";
    public static final String EXACT_MATCH = "Exact Function Bytes Match";
    public static final String FUNCTION_MINIMUM_SIZE = "Function Minimum Size";
    public static final int FUNCTION_MINIMUM_SIZE_DEFAULT = 10;

    @Override
    public int getPriority() {
        return 20;
    }

    @Override
    protected VTProgramCorrelator doCreateCorrelator(ServiceProvider serviceProvider, Program sourceProgram, AddressSetView sourceAddressSet, Program destinationProgram, AddressSetView destinationAddressSet, VTOptions options) {
        return new FunctionMatchProgramCorrelator(serviceProvider, sourceProgram, sourceAddressSet, destinationProgram, destinationAddressSet, options, EXACT_MATCH, true, (FunctionHasher)ExactBytesFunctionHasher.INSTANCE);
    }

    @Override
    public String getName() {
        return EXACT_MATCH;
    }

    @Override
    public VTOptions createDefaultOptions() {
        VTOptions options = new VTOptions(EXACT_MATCH);
        options.setInt(FUNCTION_MINIMUM_SIZE, 10);
        return options;
    }

    @Override
    public String getDescription() {
        return DESC;
    }
}

