/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.job;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import ghidra.graph.job.MoveViewAnimatorFunctionGraphJob;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.SatelliteGraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Objects;
import org.jdesktop.animation.timing.Animator;

public class EnsureAreaVisibleAnimatorFunctionGraphJob<V extends VisualVertex, E extends VisualEdge<V>>
extends MoveViewAnimatorFunctionGraphJob<V, E> {
    private final SatelliteGraphViewer<V, E> satelliteViewer;
    private final V vertex;
    private final Rectangle visibleArea;
    private Point2D preCreatedDestinaton;

    public EnsureAreaVisibleAnimatorFunctionGraphJob(VisualizationViewer<V, E> primaryViewer, SatelliteGraphViewer<V, E> satelliteViewer, V vertex, Rectangle visibleArea, boolean useAnimation) {
        super(primaryViewer, useAnimation);
        this.satelliteViewer = Objects.requireNonNull(satelliteViewer);
        this.vertex = (VisualVertex)Objects.requireNonNull(vertex);
        this.visibleArea = Objects.requireNonNull(visibleArea);
    }

    @Override
    protected Animator createAnimator() {
        int vertexCenterX;
        Rectangle viewSpaceRectangle = GraphViewerUtils.translateRectangleFromVertexRelativeSpaceToViewSpace(this.viewer, this.vertex, this.visibleArea);
        Point newPoint = new Point((int)viewSpaceRectangle.getCenterX(), (int)viewSpaceRectangle.getCenterY());
        Rectangle vertexBounds = GraphViewerUtils.getVertexBoundsInViewSpace(this.viewer, this.vertex);
        newPoint.x = vertexCenterX = vertexBounds.x + (vertexBounds.width >> 1);
        Rectangle viewerBounds = this.viewer.getBounds();
        if (!viewerBounds.contains(viewSpaceRectangle)) {
            this.preCreatedDestinaton = newPoint;
            return super.createAnimator();
        }
        if (!this.satelliteViewer.isDocked()) {
            return null;
        }
        if (!this.satelliteViewer.isShowing()) {
            return null;
        }
        Rectangle satelliteBounds = this.satelliteViewer.getBounds();
        if (!satelliteBounds.contains(viewSpaceRectangle)) {
            return null;
        }
        this.preCreatedDestinaton = newPoint;
        return super.createAnimator();
    }

    @Override
    protected Point2D createDestination() {
        if (this.preCreatedDestinaton == null) {
            return null;
        }
        return GraphViewerUtils.getOffsetFromCenterForPointInViewSpace(this.viewer, this.preCreatedDestinaton);
    }

    @Override
    public void setOffset(Point2D offsetFromOriginalPoint) {
        if (this.preCreatedDestinaton == null) {
            return;
        }
        super.setOffset(offsetFromOriginalPoint);
    }
}

